/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.miscellaneous;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import org.neo4j.shaded.lucene9.analysis.FilteringTokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;

public class DateRecognizerFilter
extends FilteringTokenFilter {
    public static final String DATE_TYPE = "date";
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final DateFormat dateFormat;

    public DateRecognizerFilter(TokenStream input) {
        this(input, null);
    }

    public DateRecognizerFilter(TokenStream input, DateFormat dateFormat) {
        super(input);
        this.dateFormat = dateFormat != null ? dateFormat : DateFormat.getDateInstance(2, Locale.ENGLISH);
    }

    @Override
    public boolean accept() {
        try {
            this.dateFormat.parse(this.termAtt.toString());
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

