/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.te;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.CharArraySet;
import org.neo4j.shaded.lucene9.analysis.StopFilter;
import org.neo4j.shaded.lucene9.analysis.StopwordAnalyzerBase;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.WordlistLoader;
import org.neo4j.shaded.lucene9.analysis.core.DecimalDigitFilter;
import org.neo4j.shaded.lucene9.analysis.in.IndicNormalizationFilter;
import org.neo4j.shaded.lucene9.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.neo4j.shaded.lucene9.analysis.standard.StandardTokenizer;
import org.neo4j.shaded.lucene9.analysis.te.TeluguNormalizationFilter;
import org.neo4j.shaded.lucene9.analysis.te.TeluguStemFilter;
import org.neo4j.shaded.lucene9.util.IOUtils;

public final class TeluguAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public TeluguAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    public TeluguAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public TeluguAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new DecimalDigitFilter(source);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new IndicNormalizationFilter(result);
        result = new TeluguNormalizationFilter(result);
        result = new StopFilter(result, this.stopwords);
        result = new TeluguStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new DecimalDigitFilter(in);
        result = new IndicNormalizationFilter(result);
        result = new TeluguNormalizationFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(TeluguAnalyzer.class.getResourceAsStream(TeluguAnalyzer.DEFAULT_STOPWORD_FILE), TeluguAnalyzer.DEFAULT_STOPWORD_FILE), TeluguAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

