/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.tokenattributes;

import org.neo4j.shaded.lucene9.analysis.tokenattributes.OffsetAttribute;
import org.neo4j.shaded.lucene9.util.AttributeImpl;
import org.neo4j.shaded.lucene9.util.AttributeReflector;

public class OffsetAttributeImpl
extends AttributeImpl
implements OffsetAttribute {
    private int startOffset;
    private int endOffset;

    @Override
    public int startOffset() {
        return this.startOffset;
    }

    @Override
    public void setOffset(int startOffset, int endOffset) {
        if (startOffset < 0 || endOffset < startOffset) {
            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset; got startOffset=" + startOffset + ",endOffset=" + endOffset);
        }
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public int endOffset() {
        return this.endOffset;
    }

    @Override
    public void clear() {
        this.startOffset = 0;
        this.endOffset = 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof OffsetAttributeImpl) {
            OffsetAttributeImpl o = (OffsetAttributeImpl)other;
            return o.startOffset == this.startOffset && o.endOffset == this.endOffset;
        }
        return false;
    }

    public int hashCode() {
        int code = this.startOffset;
        code = code * 31 + this.endOffset;
        return code;
    }

    @Override
    public void copyTo(AttributeImpl target) {
        OffsetAttribute t = (OffsetAttribute)((Object)target);
        t.setOffset(this.startOffset, this.endOffset);
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        reflector.reflect(OffsetAttribute.class, "startOffset", this.startOffset);
        reflector.reflect(OffsetAttribute.class, "endOffset", this.endOffset);
    }
}

