/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.tokenattributes;

import org.neo4j.shaded.lucene9.analysis.tokenattributes.TermFrequencyAttribute;
import org.neo4j.shaded.lucene9.util.AttributeImpl;
import org.neo4j.shaded.lucene9.util.AttributeReflector;

public class TermFrequencyAttributeImpl
extends AttributeImpl
implements TermFrequencyAttribute {
    private int termFrequency = 1;

    @Override
    public void setTermFrequency(int termFrequency) {
        if (termFrequency < 1) {
            throw new IllegalArgumentException("Term frequency must be 1 or greater; got " + termFrequency);
        }
        this.termFrequency = termFrequency;
    }

    @Override
    public int getTermFrequency() {
        return this.termFrequency;
    }

    @Override
    public void clear() {
        this.termFrequency = 1;
    }

    @Override
    public void end() {
        this.termFrequency = 1;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TermFrequencyAttributeImpl) {
            TermFrequencyAttributeImpl _other = (TermFrequencyAttributeImpl)other;
            return this.termFrequency == _other.termFrequency;
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.termFrequency);
    }

    @Override
    public void copyTo(AttributeImpl target) {
        TermFrequencyAttribute t = (TermFrequencyAttribute)((Object)target);
        t.setTermFrequency(this.termFrequency);
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        reflector.reflect(TermFrequencyAttribute.class, "termFrequency", this.termFrequency);
    }
}

