/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.backward_codecs.lucene50;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import org.neo4j.shaded.lucene9.backward_codecs.lucene50.Lucene50SkipReader;
import org.neo4j.shaded.lucene9.index.Impact;
import org.neo4j.shaded.lucene9.index.Impacts;
import org.neo4j.shaded.lucene9.store.ByteArrayDataInput;
import org.neo4j.shaded.lucene9.store.IndexInput;
import org.neo4j.shaded.lucene9.util.ArrayUtil;

final class Lucene50ScoreSkipReader
extends Lucene50SkipReader {
    private final byte[][] impactData;
    private final int[] impactDataLength;
    private final ByteArrayDataInput badi = new ByteArrayDataInput();
    private final Impacts impacts;
    private int numLevels = 1;
    private final MutableImpactList[] perLevelImpacts;

    public Lucene50ScoreSkipReader(int version, IndexInput skipStream, int maxSkipLevels, boolean hasPos, boolean hasOffsets, boolean hasPayloads) {
        super(version, skipStream, maxSkipLevels, hasPos, hasOffsets, hasPayloads);
        if (version < 1) {
            throw new IllegalStateException("Cannot skip based on scores if impacts are not indexed");
        }
        this.impactData = new byte[maxSkipLevels][];
        Arrays.fill((Object[])this.impactData, new byte[0]);
        this.impactDataLength = new int[maxSkipLevels];
        this.perLevelImpacts = new MutableImpactList[maxSkipLevels];
        for (int i = 0; i < this.perLevelImpacts.length; ++i) {
            this.perLevelImpacts[i] = new MutableImpactList();
        }
        this.impacts = new Impacts(){

            @Override
            public int numLevels() {
                return Lucene50ScoreSkipReader.this.numLevels;
            }

            @Override
            public int getDocIdUpTo(int level) {
                return Lucene50ScoreSkipReader.this.skipDoc[level];
            }

            @Override
            public List<Impact> getImpacts(int level) {
                assert (level < Lucene50ScoreSkipReader.this.numLevels);
                if (Lucene50ScoreSkipReader.this.impactDataLength[level] > 0) {
                    Lucene50ScoreSkipReader.this.badi.reset(Lucene50ScoreSkipReader.this.impactData[level], 0, Lucene50ScoreSkipReader.this.impactDataLength[level]);
                    Lucene50ScoreSkipReader.this.perLevelImpacts[level] = Lucene50ScoreSkipReader.readImpacts(Lucene50ScoreSkipReader.this.badi, Lucene50ScoreSkipReader.this.perLevelImpacts[level]);
                    Lucene50ScoreSkipReader.this.impactDataLength[level] = 0;
                }
                return Lucene50ScoreSkipReader.this.perLevelImpacts[level];
            }
        };
    }

    @Override
    public int skipTo(int target) throws IOException {
        int result = super.skipTo(target);
        if (this.numberOfSkipLevels > 0) {
            this.numLevels = this.numberOfSkipLevels;
        } else {
            this.numLevels = 1;
            this.perLevelImpacts[0].length = 1;
            this.perLevelImpacts[0].impacts[0].freq = Integer.MAX_VALUE;
            this.perLevelImpacts[0].impacts[0].norm = 1L;
            this.impactDataLength[0] = 0;
        }
        return result;
    }

    Impacts getImpacts() {
        return this.impacts;
    }

    @Override
    protected void readImpacts(int level, IndexInput skipStream) throws IOException {
        int length = skipStream.readVInt();
        if (this.impactData[level].length < length) {
            this.impactData[level] = new byte[ArrayUtil.oversize(length, 1)];
        }
        skipStream.readBytes(this.impactData[level], 0, length);
        this.impactDataLength[level] = length;
    }

    static MutableImpactList readImpacts(ByteArrayDataInput in, MutableImpactList reuse) {
        int maxNumImpacts = in.length();
        if (reuse.impacts.length < maxNumImpacts) {
            int oldLength = reuse.impacts.length;
            reuse.impacts = ArrayUtil.grow(reuse.impacts, maxNumImpacts);
            for (int i = oldLength; i < reuse.impacts.length; ++i) {
                reuse.impacts[i] = new Impact(Integer.MAX_VALUE, 1L);
            }
        }
        int freq = 0;
        long norm = 0L;
        int length = 0;
        while (in.getPosition() < in.length()) {
            int freqDelta = in.readVInt();
            if ((freqDelta & 1) != 0) {
                freq += 1 + (freqDelta >>> 1);
                try {
                    norm += 1L + in.readZLong();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                freq += 1 + (freqDelta >>> 1);
            }
            Impact impact = reuse.impacts[length];
            impact.freq = freq;
            impact.norm = ++norm;
            ++length;
        }
        reuse.length = length;
        return reuse;
    }

    static class MutableImpactList
    extends AbstractList<Impact>
    implements RandomAccess {
        int length = 1;
        Impact[] impacts = new Impact[]{new Impact(Integer.MAX_VALUE, 1L)};

        MutableImpactList() {
        }

        @Override
        public Impact get(int index) {
            return this.impacts[index];
        }

        @Override
        public int size() {
            return this.length;
        }
    }
}

