/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.backward_codecs.lucene50.compressing;

import java.io.IOException;
import org.neo4j.shaded.lucene9.backward_codecs.compressing.CompressionMode;
import org.neo4j.shaded.lucene9.backward_codecs.lucene50.compressing.Lucene50CompressingTermVectorsReader;
import org.neo4j.shaded.lucene9.codecs.TermVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.TermVectorsReader;
import org.neo4j.shaded.lucene9.codecs.TermVectorsWriter;
import org.neo4j.shaded.lucene9.index.FieldInfos;
import org.neo4j.shaded.lucene9.index.SegmentInfo;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.IOContext;

public class Lucene50CompressingTermVectorsFormat
extends TermVectorsFormat {
    protected final String formatName;
    protected final String segmentSuffix;
    protected final CompressionMode compressionMode;
    protected final int chunkSize;
    protected final int blockSize;
    protected final int maxDocsPerChunk;

    public Lucene50CompressingTermVectorsFormat(String formatName, String segmentSuffix, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockSize) {
        this.formatName = formatName;
        this.segmentSuffix = segmentSuffix;
        this.compressionMode = compressionMode;
        if (chunkSize < 1) {
            throw new IllegalArgumentException("chunkSize must be >= 1");
        }
        this.chunkSize = chunkSize;
        this.maxDocsPerChunk = maxDocsPerChunk;
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize must be >= 1");
        }
        this.blockSize = blockSize;
    }

    @Override
    public final TermVectorsReader vectorsReader(Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext context) throws IOException {
        return new Lucene50CompressingTermVectorsReader(directory, segmentInfo, this.segmentSuffix, fieldInfos, context, this.formatName, this.compressionMode);
    }

    @Override
    public TermVectorsWriter vectorsWriter(Directory directory, SegmentInfo segmentInfo, IOContext context) throws IOException {
        throw new UnsupportedOperationException("Old formats can't be used for writing");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(compressionMode=" + this.compressionMode + ", chunkSize=" + this.chunkSize + ", maxDocsPerChunk=" + this.maxDocsPerChunk + ", blockSize=" + this.blockSize + ")";
    }
}

