/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.neo4j.shaded.lucene9.document.BinaryRangeFieldRangeQuery;
import org.neo4j.shaded.lucene9.document.FloatRange;
import org.neo4j.shaded.lucene9.document.RangeFieldQuery;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.QueryVisitor;

class FloatRangeSlowRangeQuery
extends BinaryRangeFieldRangeQuery {
    private final String field;
    private final float[] min;
    private final float[] max;

    FloatRangeSlowRangeQuery(String field, float[] min, float[] max, RangeFieldQuery.QueryType queryType) {
        super(field, FloatRangeSlowRangeQuery.encodeRanges(min, max), 4, min.length, queryType);
        this.field = field;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        FloatRangeSlowRangeQuery that = (FloatRangeSlowRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Arrays.equals(this.min, that.min) && Arrays.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Arrays.hashCode(this.min);
        h = 31 * h + Arrays.hashCode(this.max);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(Arrays.toString(this.min)).append(" TO ").append(Arrays.toString(this.max)).append("]").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return super.rewrite(indexSearcher);
    }

    private static byte[] encodeRanges(float[] min, float[] max) {
        byte[] result = new byte[8 * min.length];
        FloatRange.verifyAndEncode(min, max, result);
        return result;
    }
}

