/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.document;

import org.neo4j.shaded.lucene9.document.BinaryRangeDocValuesField;
import org.neo4j.shaded.lucene9.document.IntRange;
import org.neo4j.shaded.lucene9.document.IntRangeSlowRangeQuery;
import org.neo4j.shaded.lucene9.document.RangeFieldQuery;
import org.neo4j.shaded.lucene9.search.Query;

public class IntRangeDocValuesField
extends BinaryRangeDocValuesField {
    final String field;
    final int[] min;
    final int[] max;

    public IntRangeDocValuesField(String field, int[] min, int[] max) {
        super(field, IntRange.encode(min, max), min.length, 4);
        IntRangeDocValuesField.checkArgs(min, max);
        this.field = field;
        this.min = min;
        this.max = max;
    }

    public int getMin(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.min[dimension];
    }

    public int getMax(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.max[dimension];
    }

    private static Query newSlowRangeQuery(String field, int[] min, int[] max, RangeFieldQuery.QueryType queryType) {
        IntRangeDocValuesField.checkArgs(min, max);
        return new IntRangeSlowRangeQuery(field, min, max, queryType);
    }

    public static Query newSlowIntersectsQuery(String field, int[] min, int[] max) {
        return IntRangeDocValuesField.newSlowRangeQuery(field, min, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    private static void checkArgs(int[] min, int[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        for (int i = 0; i < min.length; ++i) {
            if (min[i] <= max[i]) continue;
            throw new IllegalArgumentException("min should be less than max but min = " + min[i] + " and max = " + max[i]);
        }
    }
}

