/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.document;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.shaded.lucene9.index.DocValues;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.index.NumericDocValues;
import org.neo4j.shaded.lucene9.index.SortedNumericDocValues;
import org.neo4j.shaded.lucene9.search.ConstantScoreScorer;
import org.neo4j.shaded.lucene9.search.ConstantScoreWeight;
import org.neo4j.shaded.lucene9.search.FieldExistsQuery;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.MatchNoDocsQuery;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.QueryVisitor;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.TwoPhaseIterator;
import org.neo4j.shaded.lucene9.search.Weight;

final class SortedNumericDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;

    SortedNumericDocValuesRangeQuery(String field, long lowerValue, long upperValue) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SortedNumericDocValuesRangeQuery that = (SortedNumericDocValuesRangeQuery)obj;
        return Objects.equals(this.field, that.field) && this.lowerValue == that.lowerValue && this.upperValue == that.upperValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.lowerValue, this.upperValue);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new FieldExistsQuery(this.field);
        }
        if (this.lowerValue > this.upperValue) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedNumericDocValuesRangeQuery.this.field);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                if (context.reader().getFieldInfos().fieldInfo(SortedNumericDocValuesRangeQuery.this.field) == null) {
                    return null;
                }
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), SortedNumericDocValuesRangeQuery.this.field);
                final NumericDocValues singleton = DocValues.unwrapSingleton(values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(singleton){

                    @Override
                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return value >= SortedNumericDocValuesRangeQuery.this.lowerValue && value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                    }

                    @Override
                    public float matchCost() {
                        return 2.0f;
                    }
                } : new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            if (value < SortedNumericDocValuesRangeQuery.this.lowerValue) continue;
                            return value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 2.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }
        };
    }
}

