/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.BufferedUpdates;
import org.neo4j.shaded.lucene9.index.DocValuesType;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.store.DataInput;
import org.neo4j.shaded.lucene9.store.DataOutput;
import org.neo4j.shaded.lucene9.util.ArrayUtil;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;

abstract class DocValuesUpdate {
    private static final int RAW_SIZE_IN_BYTES = 8 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 32;
    final DocValuesType type;
    final Term term;
    final String field;
    final int docIDUpTo;
    final boolean hasValue;

    protected DocValuesUpdate(DocValuesType type, Term term, String field, int docIDUpTo, boolean hasValue) {
        assert (docIDUpTo >= 0) : docIDUpTo + " must be >= 0";
        this.type = type;
        this.term = term;
        this.field = field;
        this.docIDUpTo = docIDUpTo;
        this.hasValue = hasValue;
    }

    abstract long valueSizeInBytes();

    final long sizeInBytes() {
        long sizeInBytes = RAW_SIZE_IN_BYTES;
        sizeInBytes += (long)this.term.field.length() * 2L;
        sizeInBytes += (long)this.term.bytes.bytes.length;
        sizeInBytes += (long)this.field.length() * 2L;
        sizeInBytes += this.valueSizeInBytes();
        return ++sizeInBytes;
    }

    protected abstract String valueToString();

    abstract void writeTo(DataOutput var1) throws IOException;

    boolean hasValue() {
        return this.hasValue;
    }

    public String toString() {
        return "term=" + this.term + ",field=" + this.field + ",value=" + this.valueToString() + ",docIDUpTo=" + this.docIDUpTo;
    }

    static final class NumericDocValuesUpdate
    extends DocValuesUpdate {
        private final long value;

        NumericDocValuesUpdate(Term term, String field, long value) {
            this(term, field, value, (int)BufferedUpdates.MAX_INT, true);
        }

        NumericDocValuesUpdate(Term term, String field, Long value) {
            this(term, field, value != null ? value : -1L, (int)BufferedUpdates.MAX_INT, value != null);
        }

        private NumericDocValuesUpdate(Term term, String field, long value, int docIDUpTo, boolean hasValue) {
            super(DocValuesType.NUMERIC, term, field, docIDUpTo, hasValue);
            this.value = value;
        }

        NumericDocValuesUpdate prepareForApply(int docIDUpTo) {
            if (docIDUpTo == this.docIDUpTo) {
                return this;
            }
            return new NumericDocValuesUpdate(this.term, this.field, this.value, docIDUpTo, this.hasValue);
        }

        @Override
        long valueSizeInBytes() {
            return 8L;
        }

        @Override
        protected String valueToString() {
            return this.hasValue ? Long.toString(this.value) : "null";
        }

        @Override
        void writeTo(DataOutput out) throws IOException {
            assert (this.hasValue);
            out.writeZLong(this.value);
        }

        static long readFrom(DataInput in) throws IOException {
            return in.readZLong();
        }

        long getValue() {
            assert (this.hasValue) : "getValue should only be called if this update has a value";
            return this.value;
        }
    }

    static final class BinaryDocValuesUpdate
    extends DocValuesUpdate {
        private final BytesRef value;
        private static final long RAW_VALUE_SIZE_IN_BYTES = 8L + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;

        BinaryDocValuesUpdate(Term term, String field, BytesRef value) {
            this(term, field, value, BufferedUpdates.MAX_INT);
        }

        private BinaryDocValuesUpdate(Term term, String field, BytesRef value, int docIDUpTo) {
            super(DocValuesType.BINARY, term, field, docIDUpTo, value != null);
            this.value = value;
        }

        BinaryDocValuesUpdate prepareForApply(int docIDUpTo) {
            if (docIDUpTo == this.docIDUpTo) {
                return this;
            }
            return new BinaryDocValuesUpdate(this.term, this.field, this.value, docIDUpTo);
        }

        @Override
        long valueSizeInBytes() {
            return RAW_VALUE_SIZE_IN_BYTES + (long)(this.value == null ? 0 : this.value.bytes.length);
        }

        @Override
        protected String valueToString() {
            return this.value.toString();
        }

        BytesRef getValue() {
            assert (this.hasValue) : "getValue should only be called if this update has a value";
            return this.value;
        }

        @Override
        void writeTo(DataOutput out) throws IOException {
            assert (this.hasValue);
            out.writeVInt(this.value.length);
            out.writeBytes(this.value.bytes, this.value.offset, this.value.length);
        }

        static BytesRef readFrom(DataInput in, BytesRef scratch) throws IOException {
            scratch.length = in.readVInt();
            if (scratch.bytes.length < scratch.length) {
                scratch.bytes = ArrayUtil.grow(scratch.bytes, scratch.length);
            }
            in.readBytes(scratch.bytes, 0, scratch.length);
            return scratch;
        }
    }
}

