/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntConsumer;
import org.neo4j.shaded.lucene9.index.BinaryDocValuesFieldUpdates;
import org.neo4j.shaded.lucene9.index.BufferedUpdates;
import org.neo4j.shaded.lucene9.index.BufferedUpdatesStream;
import org.neo4j.shaded.lucene9.index.DocValuesFieldUpdates;
import org.neo4j.shaded.lucene9.index.FieldTermIterator;
import org.neo4j.shaded.lucene9.index.FieldUpdatesBuffer;
import org.neo4j.shaded.lucene9.index.Fields;
import org.neo4j.shaded.lucene9.index.LeafReader;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.index.NumericDocValuesFieldUpdates;
import org.neo4j.shaded.lucene9.index.PostingsEnum;
import org.neo4j.shaded.lucene9.index.PrefixCodedTerms;
import org.neo4j.shaded.lucene9.index.SegmentCommitInfo;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.Weight;
import org.neo4j.shaded.lucene9.util.Bits;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.InfoStream;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;

final class FrozenBufferedUpdates {
    static final int BYTES_PER_DEL_QUERY = RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4 + 24;
    final PrefixCodedTerms deleteTerms;
    final Query[] deleteQueries;
    final int[] deleteQueryLimits;
    public final CountDownLatch applied = new CountDownLatch(1);
    private final ReentrantLock applyLock = new ReentrantLock();
    private final Map<String, FieldUpdatesBuffer> fieldUpdates;
    public long totalDelCount;
    private final int fieldUpdatesCount;
    final int bytesUsed;
    private long delGen = -1L;
    final SegmentCommitInfo privateSegment;
    private final InfoStream infoStream;

    public FrozenBufferedUpdates(InfoStream infoStream, BufferedUpdates updates, SegmentCommitInfo privateSegment) {
        this.infoStream = infoStream;
        this.privateSegment = privateSegment;
        assert (privateSegment == null || updates.deleteTerms.isEmpty()) : "segment private packet should only have del queries";
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        updates.deleteTerms.forEachOrdered((term, doc) -> builder.add(term));
        this.deleteTerms = builder.finish();
        this.deleteQueries = new Query[updates.deleteQueries.size()];
        this.deleteQueryLimits = new int[updates.deleteQueries.size()];
        int upto = 0;
        for (Map.Entry<Query, Integer> ent : updates.deleteQueries.entrySet()) {
            this.deleteQueries[upto] = ent.getKey();
            this.deleteQueryLimits[upto] = ent.getValue();
            ++upto;
        }
        updates.fieldUpdates.values().forEach(FieldUpdatesBuffer::finish);
        this.fieldUpdates = Map.copyOf(updates.fieldUpdates);
        this.fieldUpdatesCount = updates.numFieldUpdates.get();
        this.bytesUsed = (int)(this.deleteTerms.ramBytesUsed() + (long)this.deleteQueries.length * (long)BYTES_PER_DEL_QUERY + updates.fieldUpdatesBytesUsed.get());
        if (infoStream != null && infoStream.isEnabled("BD")) {
            infoStream.message("BD", String.format(Locale.ROOT, "compressed %d to %d bytes (%.2f%%) for deletes/updates; private segment %s", updates.ramBytesUsed(), this.bytesUsed, 100.0 * (double)this.bytesUsed / (double)updates.ramBytesUsed(), privateSegment));
        }
    }

    boolean tryLock() {
        return this.applyLock.tryLock();
    }

    void lock() {
        this.applyLock.lock();
    }

    void unlock() {
        this.applyLock.unlock();
    }

    boolean isApplied() {
        assert (this.applyLock.isHeldByCurrentThread());
        return this.applied.getCount() == 0L;
    }

    long apply(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        assert (this.applyLock.isHeldByCurrentThread());
        if (this.delGen == -1L) {
            throw new IllegalArgumentException("gen is not yet set; call BufferedUpdatesStream.push first");
        }
        assert (this.applied.getCount() != 0L);
        if (this.privateSegment != null) {
            assert (segStates.length == 1);
            assert (this.privateSegment == segStates[0].reader.getOriginalSegmentInfo());
        }
        this.totalDelCount += this.applyTermDeletes(segStates);
        this.totalDelCount += this.applyQueryDeletes(segStates);
        this.totalDelCount += this.applyDocValuesUpdates(segStates);
        return this.totalDelCount;
    }

    private long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.fieldUpdates.isEmpty()) {
            return 0L;
        }
        long startNS = System.nanoTime();
        long updateCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            boolean isSegmentPrivateDeletes;
            if (this.delGen < segState.delGen || segState.rld.refCount() == 1) continue;
            boolean bl = isSegmentPrivateDeletes = this.privateSegment != null;
            if (this.fieldUpdates.isEmpty()) continue;
            updateCount += FrozenBufferedUpdates.applyDocValuesUpdates(segState, this.fieldUpdates, this.delGen, isSegmentPrivateDeletes);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyDocValuesUpdates %.1f msec for %d segments, %d field updates; %d new updates", (double)(System.nanoTime() - startNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L), segStates.length, this.fieldUpdatesCount, updateCount));
        }
        return updateCount;
    }

    private static long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState segState, Map<String, FieldUpdatesBuffer> updates, long delGen, boolean segmentPrivateDeletes) throws IOException {
        long updateCount = 0L;
        ArrayList<BinaryDocValuesFieldUpdates> resolvedUpdates = new ArrayList<BinaryDocValuesFieldUpdates>();
        for (Map.Entry<String, FieldUpdatesBuffer> entry : updates.entrySet()) {
            FieldUpdatesBuffer.BufferedUpdate bufferedUpdate;
            String updateField = entry.getKey();
            DocValuesFieldUpdates dvUpdates = null;
            FieldUpdatesBuffer value = entry.getValue();
            boolean isNumeric = value.isNumeric();
            FieldUpdatesBuffer.BufferedUpdateIterator iterator = value.iterator();
            TermDocsIterator termDocsIterator = new TermDocsIterator(segState.reader, iterator.isSortedTerms());
            while ((bufferedUpdate = iterator.next()) != null) {
                int doc2;
                BytesRef binaryValue;
                long longValue;
                int limit;
                DocIdSetIterator docIdSetIterator = termDocsIterator.nextTerm(bufferedUpdate.termField, bufferedUpdate.termValue);
                if (docIdSetIterator == null) continue;
                if (delGen == segState.delGen) {
                    assert (segmentPrivateDeletes);
                    limit = bufferedUpdate.docUpTo;
                } else {
                    limit = Integer.MAX_VALUE;
                }
                if (!bufferedUpdate.hasValue) {
                    longValue = -1L;
                    binaryValue = null;
                } else {
                    longValue = bufferedUpdate.numericValue;
                    binaryValue = bufferedUpdate.binaryValue;
                }
                if (dvUpdates == null) {
                    dvUpdates = isNumeric ? (value.hasSingleValue() ? new NumericDocValuesFieldUpdates.SingleValueNumericDocValuesFieldUpdates(delGen, updateField, segState.reader.maxDoc(), value.getNumericValue(0)) : new NumericDocValuesFieldUpdates(delGen, updateField, value.getMinNumeric(), value.getMaxNumeric(), segState.reader.maxDoc())) : new BinaryDocValuesFieldUpdates(delGen, updateField, segState.reader.maxDoc());
                    resolvedUpdates.add((BinaryDocValuesFieldUpdates)dvUpdates);
                }
                BinaryDocValuesFieldUpdates update = dvUpdates;
                IntConsumer docIdConsumer = !bufferedUpdate.hasValue ? doc -> update.reset(doc) : (isNumeric ? doc -> update.add(doc, longValue) : doc -> update.add(doc, binaryValue));
                Bits acceptDocs = segState.rld.getLiveDocs();
                if (segState.rld.sortMap != null && segmentPrivateDeletes) {
                    int doc3;
                    while ((doc3 = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
                        if (acceptDocs != null && !acceptDocs.get(doc3) || segState.rld.sortMap.newToOld(doc3) >= limit) continue;
                        docIdConsumer.accept(doc3);
                        ++updateCount;
                    }
                    continue;
                }
                while ((doc2 = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE && doc2 < limit) {
                    if (acceptDocs != null && !acceptDocs.get(doc2)) continue;
                    docIdConsumer.accept(doc2);
                    ++updateCount;
                }
            }
        }
        for (DocValuesFieldUpdates docValuesFieldUpdates : resolvedUpdates) {
            if (!docValuesFieldUpdates.any()) continue;
            docValuesFieldUpdates.finish();
            segState.rld.addDVUpdate(docValuesFieldUpdates);
        }
        return updateCount;
    }

    private long applyQueryDeletes(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.deleteQueries.length == 0) {
            return 0L;
        }
        long startNS = System.nanoTime();
        long delCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            if (this.delGen < segState.delGen || segState.rld.refCount() == 1) continue;
            LeafReaderContext readerContext = segState.reader.getContext();
            for (int i = 0; i < this.deleteQueries.length; ++i) {
                int docID;
                int limit;
                Query query = this.deleteQueries[i];
                if (this.delGen == segState.delGen) {
                    assert (this.privateSegment != null);
                    limit = this.deleteQueryLimits[i];
                } else {
                    limit = Integer.MAX_VALUE;
                }
                IndexSearcher searcher = new IndexSearcher(readerContext.reader());
                searcher.setQueryCache(null);
                query = searcher.rewrite(query);
                Weight weight = searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                Scorer scorer = weight.scorer(readerContext);
                if (scorer == null) continue;
                DocIdSetIterator it = scorer.iterator();
                if (segState.rld.sortMap != null && limit != Integer.MAX_VALUE) {
                    assert (this.privateSegment != null);
                    while ((docID = it.nextDoc()) != Integer.MAX_VALUE) {
                        if (segState.rld.sortMap.newToOld(docID) >= limit || !segState.rld.delete(docID)) continue;
                        ++delCount;
                    }
                    continue;
                }
                while ((docID = it.nextDoc()) < limit) {
                    if (!segState.rld.delete(docID)) continue;
                    ++delCount;
                }
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyQueryDeletes took %.2f msec for %d segments and %d queries; %d new deletions", (double)(System.nanoTime() - startNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L), segStates.length, this.deleteQueries.length, delCount));
        }
        return delCount;
    }

    private long applyTermDeletes(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.deleteTerms.size() == 0L) {
            return 0L;
        }
        assert (this.privateSegment == null);
        long startNS = System.nanoTime();
        long delCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            BytesRef delTerm;
            assert (segState.delGen != this.delGen) : "segState.delGen=" + segState.delGen + " vs this.gen=" + this.delGen;
            if (segState.delGen > this.delGen || segState.rld.refCount() == 1) continue;
            PrefixCodedTerms.TermIterator iter = this.deleteTerms.iterator();
            TermDocsIterator termDocsIterator = new TermDocsIterator(segState.reader, true);
            while ((delTerm = iter.next()) != null) {
                int docID;
                DocIdSetIterator iterator = termDocsIterator.nextTerm(((FieldTermIterator)iter).field(), delTerm);
                if (iterator == null) continue;
                while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                    if (!segState.rld.delete(docID)) continue;
                    ++delCount;
                }
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyTermDeletes took %.2f msec for %d segments and %d del terms; %d new deletions", (double)(System.nanoTime() - startNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L), segStates.length, this.deleteTerms.size(), delCount));
        }
        return delCount;
    }

    public void setDelGen(long delGen) {
        assert (this.delGen == -1L) : "delGen was already previously set to " + this.delGen;
        this.delGen = delGen;
        this.deleteTerms.setDelGen(delGen);
    }

    public long delGen() {
        assert (this.delGen != -1L);
        return this.delGen;
    }

    public String toString() {
        String s = "delGen=" + this.delGen;
        if (this.deleteTerms.size() != 0L) {
            s = s + " unique deleteTerms=" + this.deleteTerms.size();
        }
        if (this.deleteQueries.length != 0) {
            s = s + " numDeleteQueries=" + this.deleteQueries.length;
        }
        if (this.fieldUpdates.size() > 0) {
            s = s + " fieldUpdates=" + this.fieldUpdatesCount;
        }
        if (this.bytesUsed != 0) {
            s = s + " bytesUsed=" + this.bytesUsed;
        }
        if (this.privateSegment != null) {
            s = s + " privateSegment=" + this.privateSegment;
        }
        return s;
    }

    boolean any() {
        return this.deleteTerms.size() > 0L || this.deleteQueries.length > 0 || this.fieldUpdatesCount > 0;
    }

    static final class TermDocsIterator {
        private final TermsProvider provider;
        private String field;
        private TermsEnum termsEnum;
        private PostingsEnum postingsEnum;
        private final boolean sortedTerms;
        private BytesRef readerTerm;
        private BytesRef lastTerm;

        TermDocsIterator(Fields fields, boolean sortedTerms) {
            this(fields::terms, sortedTerms);
        }

        TermDocsIterator(LeafReader reader, boolean sortedTerms) {
            this(reader::terms, sortedTerms);
        }

        private TermDocsIterator(TermsProvider provider, boolean sortedTerms) {
            this.sortedTerms = sortedTerms;
            this.provider = provider;
        }

        private void setField(String field) throws IOException {
            if (this.field == null || !this.field.equals(field)) {
                this.field = field;
                Terms terms = this.provider.terms(field);
                if (terms != null) {
                    this.termsEnum = terms.iterator();
                    if (this.sortedTerms) {
                        if (!$assertionsDisabled) {
                            this.lastTerm = null;
                            if (null != null) {
                                throw new AssertionError();
                            }
                        }
                        this.readerTerm = this.termsEnum.next();
                    }
                } else {
                    this.termsEnum = null;
                }
            }
        }

        DocIdSetIterator nextTerm(String field, BytesRef term) throws IOException {
            this.setField(field);
            if (this.termsEnum != null) {
                if (this.sortedTerms) {
                    assert (this.assertSorted(term));
                    int cmp = term.compareTo(this.readerTerm);
                    if (cmp < 0) {
                        return null;
                    }
                    if (cmp == 0) {
                        return this.getDocs();
                    }
                    TermsEnum.SeekStatus status = this.termsEnum.seekCeil(term);
                    switch (status) {
                        case FOUND: {
                            return this.getDocs();
                        }
                        case NOT_FOUND: {
                            this.readerTerm = this.termsEnum.term();
                            return null;
                        }
                        case END: {
                            this.termsEnum = null;
                            return null;
                        }
                    }
                    throw new AssertionError((Object)"unknown status");
                }
                if (this.termsEnum.seekExact(term)) {
                    return this.getDocs();
                }
            }
            return null;
        }

        private boolean assertSorted(BytesRef term) {
            assert (this.sortedTerms);
            assert (this.lastTerm == null || term.compareTo(this.lastTerm) >= 0) : "boom: " + term.utf8ToString() + " last: " + this.lastTerm.utf8ToString();
            this.lastTerm = BytesRef.deepCopyOf(term);
            return true;
        }

        private DocIdSetIterator getDocs() throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            return this.postingsEnum;
        }

        @FunctionalInterface
        static interface TermsProvider {
            public Terms terms(String var1) throws IOException;
        }
    }
}

