/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.BinaryDocValues;
import org.neo4j.shaded.lucene9.index.ByteVectorValues;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.index.FieldInfos;
import org.neo4j.shaded.lucene9.index.FloatVectorValues;
import org.neo4j.shaded.lucene9.index.IndexReader;
import org.neo4j.shaded.lucene9.index.LeafMetaData;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.index.NumericDocValues;
import org.neo4j.shaded.lucene9.index.PointValues;
import org.neo4j.shaded.lucene9.index.PostingsEnum;
import org.neo4j.shaded.lucene9.index.SortedDocValues;
import org.neo4j.shaded.lucene9.index.SortedNumericDocValues;
import org.neo4j.shaded.lucene9.index.SortedSetDocValues;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.search.KnnCollector;
import org.neo4j.shaded.lucene9.search.TopDocs;
import org.neo4j.shaded.lucene9.search.TopDocsCollector;
import org.neo4j.shaded.lucene9.search.TopKnnCollector;
import org.neo4j.shaded.lucene9.util.Bits;

public abstract class LeafReader
extends IndexReader {
    private final LeafReaderContext readerContext = new LeafReaderContext(this);

    protected LeafReader() {
    }

    @Override
    public final LeafReaderContext getContext() {
        this.ensureOpen();
        return this.readerContext;
    }

    public abstract IndexReader.CacheHelper getCoreCacheHelper();

    @Override
    public final int docFreq(Term term) throws IOException {
        Terms terms = Terms.getTerms(this, term.field());
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.docFreq();
        }
        return 0;
    }

    @Override
    public final long totalTermFreq(Term term) throws IOException {
        Terms terms = Terms.getTerms(this, term.field());
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.totalTermFreq();
        }
        return 0L;
    }

    @Override
    public final long getSumDocFreq(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumDocFreq();
    }

    @Override
    public final int getDocCount(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0;
        }
        return terms.getDocCount();
    }

    @Override
    public final long getSumTotalTermFreq(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumTotalTermFreq();
    }

    public abstract Terms terms(String var1) throws IOException;

    public final PostingsEnum postings(Term term, int flags) throws IOException {
        assert (term.field() != null);
        assert (term.bytes() != null);
        Terms terms = Terms.getTerms(this, term.field());
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.postings(null, flags);
        }
        return null;
    }

    public final PostingsEnum postings(Term term) throws IOException {
        return this.postings(term, 8);
    }

    public abstract NumericDocValues getNumericDocValues(String var1) throws IOException;

    public abstract BinaryDocValues getBinaryDocValues(String var1) throws IOException;

    public abstract SortedDocValues getSortedDocValues(String var1) throws IOException;

    public abstract SortedNumericDocValues getSortedNumericDocValues(String var1) throws IOException;

    public abstract SortedSetDocValues getSortedSetDocValues(String var1) throws IOException;

    public abstract NumericDocValues getNormValues(String var1) throws IOException;

    public abstract FloatVectorValues getFloatVectorValues(String var1) throws IOException;

    public abstract ByteVectorValues getByteVectorValues(String var1) throws IOException;

    public final TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        FloatVectorValues floatVectorValues = this.getFloatVectorValues(fi.name);
        if (floatVectorValues == null) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        if ((k = Math.min(k, floatVectorValues.size())) == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        TopKnnCollector collector = new TopKnnCollector(k, visitedLimit);
        this.searchNearestVectors(field, target, (KnnCollector)collector, acceptDocs);
        return collector.topDocs();
    }

    public final TopDocs searchNearestVectors(String field, byte[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        ByteVectorValues byteVectorValues = this.getByteVectorValues(fi.name);
        if (byteVectorValues == null) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        if ((k = Math.min(k, byteVectorValues.size())) == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        TopKnnCollector collector = new TopKnnCollector(k, visitedLimit);
        this.searchNearestVectors(field, target, (KnnCollector)collector, acceptDocs);
        return collector.topDocs();
    }

    public abstract void searchNearestVectors(String var1, float[] var2, KnnCollector var3, Bits var4) throws IOException;

    public abstract void searchNearestVectors(String var1, byte[] var2, KnnCollector var3, Bits var4) throws IOException;

    public abstract FieldInfos getFieldInfos();

    public abstract Bits getLiveDocs();

    public abstract PointValues getPointValues(String var1) throws IOException;

    public abstract void checkIntegrity() throws IOException;

    public abstract LeafMetaData getMetaData();
}

