/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.shaded.lucene9.codecs.DocValuesConsumer;
import org.neo4j.shaded.lucene9.codecs.DocValuesProducer;
import org.neo4j.shaded.lucene9.index.DocValues;
import org.neo4j.shaded.lucene9.index.DocValuesWriter;
import org.neo4j.shaded.lucene9.index.DocsWithFieldSet;
import org.neo4j.shaded.lucene9.index.EmptyDocValuesProducer;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.index.NumericDocValuesWriter;
import org.neo4j.shaded.lucene9.index.SegmentWriteState;
import org.neo4j.shaded.lucene9.index.SortedNumericDocValues;
import org.neo4j.shaded.lucene9.index.Sorter;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.util.ArrayUtil;
import org.neo4j.shaded.lucene9.util.Counter;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;
import org.neo4j.shaded.lucene9.util.packed.PackedLongValues;

class SortedNumericDocValuesWriter
extends DocValuesWriter<SortedNumericDocValues> {
    private final PackedLongValues.Builder pending;
    private PackedLongValues.Builder pendingCounts;
    private final DocsWithFieldSet docsWithField;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int currentDoc = -1;
    private long[] currentValues = new long[8];
    private int currentUpto = 0;
    private PackedLongValues finalValues;
    private PackedLongValues finalValuesCount;

    SortedNumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.pending = PackedLongValues.deltaPackedBuilder(0.0f);
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed() + RamUsageEstimator.sizeOf(this.currentValues);
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        assert (docID >= this.currentDoc);
        if (docID != this.currentDoc) {
            this.finishCurrentDoc();
            this.currentDoc = docID;
        }
        this.addOneValue(value);
        this.updateBytesUsed();
    }

    private void finishCurrentDoc() {
        int i;
        if (this.currentDoc == -1) {
            return;
        }
        if (this.currentUpto > 1) {
            Arrays.sort(this.currentValues, 0, this.currentUpto);
        }
        for (i = 0; i < this.currentUpto; ++i) {
            this.pending.add(this.currentValues[i]);
        }
        if (this.pendingCounts != null) {
            this.pendingCounts.add(this.currentUpto);
        } else if (this.currentUpto != 1) {
            this.pendingCounts = PackedLongValues.deltaPackedBuilder(0.0f);
            for (i = 0; i < this.docsWithField.cardinality(); ++i) {
                this.pendingCounts.add(1L);
            }
            this.pendingCounts.add(this.currentUpto);
        }
        this.currentUpto = 0;
        this.docsWithField.add(this.currentDoc);
    }

    private void addOneValue(long value) {
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.grow(this.currentValues, this.currentValues.length + 1);
        }
        this.currentValues[this.currentUpto] = value;
        ++this.currentUpto;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + (this.pendingCounts == null ? 0L : this.pendingCounts.ramBytesUsed()) + this.docsWithField.ramBytesUsed() + RamUsageEstimator.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    SortedNumericDocValues getDocValues() {
        if (this.finalValues == null) {
            assert (this.finalValuesCount == null);
            this.finishCurrentDoc();
            this.finalValues = this.pending.build();
            this.finalValuesCount = this.pendingCounts == null ? null : this.pendingCounts.build();
        }
        return this.getValues(this.finalValues, this.finalValuesCount, this.docsWithField);
    }

    private SortedNumericDocValues getValues(PackedLongValues values, PackedLongValues valueCounts, DocsWithFieldSet docsWithField) {
        if (valueCounts == null) {
            return DocValues.singleton(new NumericDocValuesWriter.BufferedNumericDocValues(values, docsWithField.iterator()));
        }
        return new BufferedSortedNumericDocValues(values, valueCounts, docsWithField.iterator());
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        PackedLongValues valueCounts;
        PackedLongValues values;
        if (this.finalValues == null) {
            this.finishCurrentDoc();
            values = this.pending.build();
            valueCounts = this.pendingCounts == null ? null : this.pendingCounts.build();
        } else {
            values = this.finalValues;
            valueCounts = this.finalValuesCount;
        }
        if (valueCounts == null) {
            final DocValuesProducer singleValueProducer = NumericDocValuesWriter.getDocValuesProducer(this.fieldInfo, values, this.docsWithField, sortMap);
            dvConsumer.addSortedNumericField(this.fieldInfo, new EmptyDocValuesProducer(){

                @Override
                public SortedNumericDocValues getSortedNumeric(FieldInfo fieldInfo) throws IOException {
                    return DocValues.singleton(singleValueProducer.getNumeric(fieldInfo));
                }
            });
            return;
        }
        final LongValues sorted = sortMap != null ? new LongValues(state.segmentInfo.maxDoc(), sortMap, this.getValues(values, valueCounts, this.docsWithField), 7.0f) : null;
        dvConsumer.addSortedNumericField(this.fieldInfo, new EmptyDocValuesProducer(){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo fieldInfoIn) {
                if (fieldInfoIn != SortedNumericDocValuesWriter.this.fieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                SortedNumericDocValues buf = SortedNumericDocValuesWriter.this.getValues(values, valueCounts, SortedNumericDocValuesWriter.this.docsWithField);
                if (sorted == null) {
                    return buf;
                }
                return new SortingSortedNumericDocValues(buf, sorted);
            }
        });
    }

    static class SortingSortedNumericDocValues
    extends SortedNumericDocValues {
        private final SortedNumericDocValues in;
        private final LongValues values;
        private int docID = -1;
        private long upto;
        private int numValues = -1;
        private long limit;

        SortingSortedNumericDocValues(SortedNumericDocValues in, LongValues values) {
            this.in = in;
            this.values = values;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            do {
                ++this.docID;
                if (this.docID < this.values.offsets.length) continue;
                this.docID = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while (this.values.offsets[this.docID] <= 0L);
            this.upto = this.values.offsets[this.docID];
            this.numValues = Math.toIntExact(this.values.values.get(this.upto - 1L));
            this.limit = this.upto + (long)this.numValues;
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            this.upto = this.values.offsets[this.docID];
            if (this.values.offsets[this.docID] > 0L) {
                this.numValues = Math.toIntExact(this.values.values.get(this.upto - 1L));
                this.limit = this.upto + (long)this.numValues;
                return true;
            }
            this.limit = this.upto;
            return false;
        }

        @Override
        public long nextValue() {
            if (this.upto == this.limit) {
                throw new AssertionError();
            }
            return this.values.values.get(this.upto++);
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int docValueCount() {
            return this.numValues;
        }
    }

    private static class BufferedSortedNumericDocValues
    extends SortedNumericDocValues {
        final PackedLongValues.Iterator valuesIter;
        final PackedLongValues.Iterator valueCountsIter;
        final DocIdSetIterator docsWithField;
        private int valueCount;
        private int valueUpto;

        BufferedSortedNumericDocValues(PackedLongValues values, PackedLongValues valueCounts, DocIdSetIterator docsWithField) {
            this.valuesIter = values.iterator();
            this.valueCountsIter = valueCounts.iterator();
            this.docsWithField = docsWithField;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            for (int i = this.valueUpto; i < this.valueCount; ++i) {
                this.valuesIter.next();
            }
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.valueCount = Math.toIntExact(this.valueCountsIter.next());
                this.valueUpto = 0;
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docValueCount() {
            return this.valueCount;
        }

        @Override
        public long nextValue() {
            if (this.valueUpto == this.valueCount) {
                throw new IllegalStateException();
            }
            ++this.valueUpto;
            return this.valuesIter.next();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }
    }

    static final class LongValues {
        final long[] offsets;
        final PackedLongValues values;

        LongValues(int maxDoc, Sorter.DocMap sortMap, SortedNumericDocValues oldValues, float acceptableOverheadRatio) throws IOException {
            int docID;
            this.offsets = new long[maxDoc];
            PackedLongValues.Builder valuesBuiler = PackedLongValues.packedBuilder(acceptableOverheadRatio);
            long offsetIndex = 1L;
            while ((docID = oldValues.nextDoc()) != Integer.MAX_VALUE) {
                int newDocID = sortMap.oldToNew(docID);
                int numValues = oldValues.docValueCount();
                valuesBuiler.add(numValues);
                ++offsetIndex;
                for (int i = 0; i < numValues; ++i) {
                    valuesBuiler.add(oldValues.nextValue());
                    ++offsetIndex;
                }
            }
            this.values = valuesBuiler.build();
        }
    }
}

