/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.shaded.lucene9.codecs.NormsProducer;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.index.FieldInvertState;
import org.neo4j.shaded.lucene9.index.SegmentWriteState;
import org.neo4j.shaded.lucene9.index.Sorter;
import org.neo4j.shaded.lucene9.index.TermsHashPerField;
import org.neo4j.shaded.lucene9.util.ByteBlockPool;
import org.neo4j.shaded.lucene9.util.Counter;
import org.neo4j.shaded.lucene9.util.IntBlockPool;

abstract class TermsHash {
    final TermsHash nextTermsHash;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    ByteBlockPool termBytePool;
    final Counter bytesUsed;

    TermsHash(IntBlockPool.Allocator intBlockAllocator, ByteBlockPool.Allocator byteBlockAllocator, Counter bytesUsed, TermsHash nextTermsHash) {
        this.nextTermsHash = nextTermsHash;
        this.bytesUsed = bytesUsed;
        this.intPool = new IntBlockPool(intBlockAllocator);
        this.bytePool = new ByteBlockPool(byteBlockAllocator);
        if (nextTermsHash != null) {
            this.termBytePool = this.bytePool;
            nextTermsHash.termBytePool = this.bytePool;
        }
    }

    public void abort() {
        try {
            this.reset();
        }
        finally {
            if (this.nextTermsHash != null) {
                this.nextTermsHash.abort();
            }
        }
    }

    void reset() {
        this.intPool.reset(false, false);
        this.bytePool.reset(false, false);
    }

    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap, NormsProducer norms) throws IOException {
        if (this.nextTermsHash != null) {
            HashMap<String, TermsHashPerField> nextChildFields = new HashMap<String, TermsHashPerField>();
            for (Map.Entry<String, TermsHashPerField> entry : fieldsToFlush.entrySet()) {
                nextChildFields.put(entry.getKey(), entry.getValue().getNextPerField());
            }
            this.nextTermsHash.flush(nextChildFields, state, sortMap, norms);
        }
    }

    abstract TermsHashPerField addField(FieldInvertState var1, FieldInfo var2);

    void finishDocument(int docID) throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.finishDocument(docID);
        }
    }

    void startDocument() throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.startDocument();
        }
    }
}

