/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders;

import java.util.List;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.QueryNodeException;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.builders.QueryTreeBuilder;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.FieldQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.QueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.core.nodes.TokenizedPhraseQueryNode;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.builders.StandardQueryBuilder;
import org.neo4j.shaded.lucene9.search.PhraseQuery;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.TermQuery;

public class PhraseQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public Query build(QueryNode queryNode) throws QueryNodeException {
        TokenizedPhraseQueryNode phraseNode = (TokenizedPhraseQueryNode)queryNode;
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        List<QueryNode> children = phraseNode.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                TermQuery termQuery = (TermQuery)child.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                FieldQueryNode termNode = (FieldQueryNode)child;
                builder.add(termQuery.getTerm(), termNode.getPositionIncrement());
            }
        }
        return builder.build();
    }
}

