/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn;

import java.io.IOException;
import java.util.regex.Pattern;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.queries.intervals.Intervals;
import org.neo4j.shaded.lucene9.queries.intervals.IntervalsSource;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class AnalyzedText
extends IntervalFunction {
    private final String term;

    public AnalyzedText(String term) {
        this.term = term;
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        int gaps = 0;
        boolean ordered = true;
        try {
            return Intervals.analyzedText((String)this.term, (Analyzer)analyzer, (String)field, (int)gaps, (boolean)ordered);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        if (AnalyzedText.requiresQuotes(this.term)) {
            return "\"" + this.term + "\"";
        }
        return this.term;
    }

    static boolean requiresQuotes(String term) {
        return Pattern.compile("[\\s]").matcher(term).find();
    }
}

