/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.queries.intervals.Intervals;
import org.neo4j.shaded.lucene9.queries.intervals.IntervalsSource;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.AnalyzedText;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class FuzzyTerm
extends IntervalFunction {
    private final String term;
    private final int maxEdits;
    private final Integer maxExpansions;

    public FuzzyTerm(String term, Integer maxEdits, Integer maxExpansions) {
        this.term = term;
        this.maxEdits = maxEdits == null ? 2 : maxEdits;
        this.maxExpansions = maxExpansions == null ? 128 : maxExpansions;
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.fuzzyTerm((String)this.term, (int)this.maxEdits, (int)0, (boolean)true, (int)this.maxExpansions);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:fuzzyTerm(%s %d%s)", AnalyzedText.requiresQuotes(this.term) ? "\"" + this.term + "\"" : this.term, this.maxEdits, this.maxExpansions);
    }
}

