/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.queries.intervals.Intervals;
import org.neo4j.shaded.lucene9.queries.intervals.IntervalsSource;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;
import org.neo4j.shaded.lucene9.util.BytesRef;

public class Wildcard
extends IntervalFunction {
    private final String wildcard;
    private final int maxExpansions;

    public Wildcard(String wildcard, int maxExpansions) {
        this.wildcard = wildcard;
        this.maxExpansions = maxExpansions;
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        if (this.maxExpansions == 0) {
            return Intervals.wildcard((BytesRef)new BytesRef(this.wildcard));
        }
        return Intervals.wildcard((BytesRef)new BytesRef(this.wildcard), (int)this.maxExpansions);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:wildcard(%s%s)", this.wildcard, this.maxExpansions == 0 ? "" : " maxExpansions:" + this.maxExpansions);
    }
}

