/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import java.util.Objects;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.queries.intervals.Intervals;
import org.neo4j.shaded.lucene9.queries.intervals.IntervalsSource;
import org.neo4j.shaded.lucene9.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class Within
extends IntervalFunction {
    private final int positions;
    private final IntervalFunction source;
    private final IntervalFunction reference;

    public Within(IntervalFunction source, int positions, IntervalFunction reference) {
        this.positions = positions;
        this.source = Objects.requireNonNull(source);
        this.reference = Objects.requireNonNull(reference);
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.within((IntervalsSource)this.source.toIntervalSource(field, analyzer), (int)this.positions, (IntervalsSource)this.reference.toIntervalSource(field, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:within(%s %d %s)", this.source, this.positions, this.reference);
    }
}

