/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.queryparser.xml.builders;

import org.neo4j.shaded.lucene9.document.DoublePoint;
import org.neo4j.shaded.lucene9.document.FloatPoint;
import org.neo4j.shaded.lucene9.document.IntPoint;
import org.neo4j.shaded.lucene9.document.LongPoint;
import org.neo4j.shaded.lucene9.queryparser.xml.DOMUtils;
import org.neo4j.shaded.lucene9.queryparser.xml.ParserException;
import org.neo4j.shaded.lucene9.queryparser.xml.QueryBuilder;
import org.neo4j.shaded.lucene9.search.Query;
import org.w3c.dom.Element;

public class PointRangeQueryBuilder
implements QueryBuilder {
    @Override
    public Query getQuery(Element e) throws ParserException {
        String field = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String lowerTerm = DOMUtils.getAttribute(e, "lowerTerm", null);
        String upperTerm = DOMUtils.getAttribute(e, "upperTerm", null);
        String type = DOMUtils.getAttribute(e, "type", "int");
        try {
            if (type.equalsIgnoreCase("int")) {
                return IntPoint.newRangeQuery(field, lowerTerm == null ? Integer.MIN_VALUE : Integer.parseInt(lowerTerm), upperTerm == null ? Integer.MAX_VALUE : Integer.parseInt(upperTerm));
            }
            if (type.equalsIgnoreCase("long")) {
                return LongPoint.newRangeQuery(field, lowerTerm == null ? Long.MIN_VALUE : Long.parseLong(lowerTerm), upperTerm == null ? Long.MAX_VALUE : Long.parseLong(upperTerm));
            }
            if (type.equalsIgnoreCase("double")) {
                return DoublePoint.newRangeQuery(field, lowerTerm == null ? Double.NEGATIVE_INFINITY : Double.parseDouble(lowerTerm), upperTerm == null ? Double.POSITIVE_INFINITY : Double.parseDouble(upperTerm));
            }
            if (type.equalsIgnoreCase("float")) {
                return FloatPoint.newRangeQuery(field, lowerTerm == null ? Float.NEGATIVE_INFINITY : Float.parseFloat(lowerTerm), upperTerm == null ? Float.POSITIVE_INFINITY : Float.parseFloat(upperTerm));
            }
            throw new ParserException("type attribute must be one of: [long, int, double, float]");
        }
        catch (NumberFormatException nfe) {
            throw new ParserException("Could not parse lowerTerm or upperTerm into a number", nfe);
        }
    }
}

