/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.neo4j.shaded.lucene9.index.ByteVectorValues;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.search.AbstractVectorSimilarityQuery;
import org.neo4j.shaded.lucene9.search.KnnCollector;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.TopDocs;
import org.neo4j.shaded.lucene9.search.VectorScorer;
import org.neo4j.shaded.lucene9.search.VectorSimilarityCollector;
import org.neo4j.shaded.lucene9.util.Bits;

public class ByteVectorSimilarityQuery
extends AbstractVectorSimilarityQuery {
    private final byte[] target;

    public ByteVectorSimilarityQuery(String field, byte[] target, float traversalSimilarity, float resultSimilarity, Query filter) {
        super(field, traversalSimilarity, resultSimilarity, filter);
        this.target = Objects.requireNonNull(target, "target");
    }

    public ByteVectorSimilarityQuery(String field, byte[] target, float traversalSimilarity, float resultSimilarity) {
        this(field, target, traversalSimilarity, resultSimilarity, null);
    }

    public ByteVectorSimilarityQuery(String field, byte[] target, float resultSimilarity, Query filter) {
        this(field, target, resultSimilarity, resultSimilarity, filter);
    }

    public ByteVectorSimilarityQuery(String field, byte[] target, float resultSimilarity) {
        this(field, target, resultSimilarity, resultSimilarity, null);
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context) throws IOException {
        ByteVectorValues vectorValues = context.reader().getByteVectorValues(this.field);
        if (vectorValues == null) {
            return null;
        }
        return vectorValues.scorer(this.target);
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitLimit) throws IOException {
        VectorSimilarityCollector collector = new VectorSimilarityCollector(this.traversalSimilarity, this.resultSimilarity, visitLimit);
        context.reader().searchNearestVectors(this.field, this.target, (KnnCollector)collector, acceptDocs);
        return collector.topDocs();
    }

    @Override
    public String toString(String field) {
        return String.format(Locale.ROOT, "%s[field=%s target=[%d...] traversalSimilarity=%f resultSimilarity=%f filter=%s]", this.getClass().getSimpleName(), field, this.target[0], Float.valueOf(this.traversalSimilarity), Float.valueOf(this.resultSimilarity), this.filter);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && super.equals(o) && Arrays.equals(this.target, ((ByteVectorSimilarityQuery)o).target);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.target);
        return result;
    }
}

