/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.shaded.lucene9.search.ConjunctionUtils;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.Scorable;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.TwoPhaseIterator;
import org.neo4j.shaded.lucene9.search.Weight;

class ConjunctionScorer
extends Scorer {
    final DocIdSetIterator disi;
    final Scorer[] scorers;
    final Collection<Scorer> required;

    ConjunctionScorer(Weight weight, Collection<Scorer> required, Collection<Scorer> scorers) {
        super(weight);
        assert (required.containsAll(scorers));
        this.disi = ConjunctionUtils.intersectScorers(required);
        this.scorers = scorers.toArray(new Scorer[scorers.size()]);
        this.required = required;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return TwoPhaseIterator.unwrap(this.disi);
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        double sum = 0.0;
        for (Scorer scorer : this.scorers) {
            sum += (double)scorer.score();
        }
        return (float)sum;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double maxScore = 0.0;
        for (Scorer s : this.scorers) {
            if (s.docID() > upTo) continue;
            maxScore += (double)s.getMaxScore(upTo);
        }
        return (float)maxScore;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        if (this.scorers.length == 1) {
            return this.scorers[0].advanceShallow(target);
        }
        for (Scorer scorer : this.scorers) {
            scorer.advanceShallow(target);
        }
        return super.advanceShallow(target);
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        if (this.scorers.length == 1) {
            this.scorers[0].setMinCompetitiveScore(minScore);
        }
    }

    @Override
    public Collection<Scorable.ChildScorable> getChildren() {
        ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
        for (Scorer scorer : this.required) {
            children.add(new Scorable.ChildScorable(scorer, "MUST"));
        }
        return children;
    }

    static final class DocsAndFreqs {
        final long cost;
        final DocIdSetIterator iterator;
        int doc = -1;

        DocsAndFreqs(DocIdSetIterator iterator) {
            this.iterator = iterator;
            this.cost = iterator.cost();
        }
    }
}

