/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.List;
import org.neo4j.shaded.lucene9.search.DisiPriorityQueue;
import org.neo4j.shaded.lucene9.search.DisiWrapper;
import org.neo4j.shaded.lucene9.search.DisjunctionDISIApproximation;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.IndriScorer;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.Weight;

public abstract class IndriDisjunctionScorer
extends IndriScorer {
    private final List<Scorer> subScorersList;
    private final DisiPriorityQueue subScorers;
    private final DocIdSetIterator approximation;

    protected IndriDisjunctionScorer(Weight weight, List<Scorer> subScorersList, ScoreMode scoreMode, float boost) {
        super(weight, boost);
        this.subScorersList = subScorersList;
        this.subScorers = new DisiPriorityQueue(subScorersList.size());
        for (Scorer scorer : subScorersList) {
            DisiWrapper w = new DisiWrapper(scorer);
            this.subScorers.add(w);
        }
        this.approximation = new DisjunctionDISIApproximation(this.subScorers);
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.approximation;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return 0.0f;
    }

    public List<Scorer> getSubMatches() throws IOException {
        return this.subScorersList;
    }

    abstract float score(List<Scorer> var1) throws IOException;

    public abstract float smoothingScore(List<Scorer> var1, int var2) throws IOException;

    @Override
    public float score() throws IOException {
        return this.score(this.getSubMatches());
    }

    @Override
    public float smoothingScore(int docId) throws IOException {
        return this.smoothingScore(this.getSubMatches(), docId);
    }

    @Override
    public int docID() {
        return this.subScorers.top().doc;
    }
}

