/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.search.BulkScorer;
import org.neo4j.shaded.lucene9.search.ConstantScoreScorer;
import org.neo4j.shaded.lucene9.search.ConstantScoreWeight;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.LeafCollector;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.QueryVisitor;
import org.neo4j.shaded.lucene9.search.ScoreAndDoc;
import org.neo4j.shaded.lucene9.search.ScoreMode;
import org.neo4j.shaded.lucene9.search.Scorer;
import org.neo4j.shaded.lucene9.search.Weight;
import org.neo4j.shaded.lucene9.util.Bits;

public final class MatchAllDocsQuery
extends Query {
    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            public String toString() {
                return "weight(" + MatchAllDocsQuery.this + ")";
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, DocIdSetIterator.all(context.reader().maxDoc()));
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                if (!scoreMode.isExhaustive()) {
                    return super.bulkScorer(context);
                }
                final float score = this.score();
                final int maxDoc = context.reader().maxDoc();
                return new BulkScorer(){

                    @Override
                    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
                        max = Math.min(max, maxDoc);
                        ScoreAndDoc scorer = new ScoreAndDoc();
                        scorer.score = score;
                        collector.setScorer(scorer);
                        for (int doc = min; doc < max; ++doc) {
                            scorer.doc = doc;
                            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
                            collector.collect(doc);
                        }
                        return max == maxDoc ? Integer.MAX_VALUE : max;
                    }

                    @Override
                    public long cost() {
                        return maxDoc;
                    }
                };
            }

            @Override
            public int count(LeafReaderContext context) {
                return context.reader().numDocs();
            }
        };
    }

    @Override
    public String toString(String field) {
        return "*:*";
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    @Override
    public int hashCode() {
        return this.classHash();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }
}

