/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.shaded.lucene9.index.IndexReader;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.index.TermStates;
import org.neo4j.shaded.lucene9.index.Terms;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.search.BlendedTermQuery;
import org.neo4j.shaded.lucene9.search.BooleanClause;
import org.neo4j.shaded.lucene9.search.BooleanQuery;
import org.neo4j.shaded.lucene9.search.BoostQuery;
import org.neo4j.shaded.lucene9.search.ConstantScoreQuery;
import org.neo4j.shaded.lucene9.search.DocValuesRewriteMethod;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.MultiTermQueryConstantScoreBlendedWrapper;
import org.neo4j.shaded.lucene9.search.MultiTermQueryConstantScoreWrapper;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.ScoringRewrite;
import org.neo4j.shaded.lucene9.search.TermQuery;
import org.neo4j.shaded.lucene9.search.TopTermsRewrite;
import org.neo4j.shaded.lucene9.util.AttributeSource;

public abstract class MultiTermQuery
extends Query {
    protected final String field;
    protected RewriteMethod rewriteMethod;
    public static final RewriteMethod CONSTANT_SCORE_BLENDED_REWRITE = new RewriteMethod(){

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            return new MultiTermQueryConstantScoreBlendedWrapper<MultiTermQuery>(query);
        }
    };
    public static final RewriteMethod CONSTANT_SCORE_REWRITE = new RewriteMethod(){

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            return new MultiTermQueryConstantScoreWrapper<MultiTermQuery>(query);
        }
    };
    public static final RewriteMethod DOC_VALUES_REWRITE = new DocValuesRewriteMethod();
    public static final RewriteMethod SCORING_BOOLEAN_REWRITE = ScoringRewrite.SCORING_BOOLEAN_REWRITE;
    public static final RewriteMethod CONSTANT_SCORE_BOOLEAN_REWRITE = ScoringRewrite.CONSTANT_SCORE_BOOLEAN_REWRITE;

    public MultiTermQuery(String field, RewriteMethod rewriteMethod) {
        this.field = Objects.requireNonNull(field, "field must not be null");
        this.rewriteMethod = Objects.requireNonNull(rewriteMethod, "rewriteMethod must not be null");
    }

    public final String getField() {
        return this.field;
    }

    protected abstract TermsEnum getTermsEnum(Terms var1, AttributeSource var2) throws IOException;

    public final TermsEnum getTermsEnum(Terms terms) throws IOException {
        return this.getTermsEnum(terms, new AttributeSource());
    }

    public long getTermsCount() throws IOException {
        return -1L;
    }

    @Override
    public final Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return this.rewriteMethod.rewrite(indexSearcher.getIndexReader(), this);
    }

    public RewriteMethod getRewriteMethod() {
        return this.rewriteMethod;
    }

    @Deprecated
    public void setRewriteMethod(RewriteMethod method) {
        this.rewriteMethod = method;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((MultiTermQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(MultiTermQuery other) {
        return this.rewriteMethod.equals(other.rewriteMethod) && this.field.equals(other.field);
    }

    public static final class TopTermsBoostOnlyBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery.Builder> {
        public TopTermsBoostOnlyBooleanQueryRewrite(int size) {
            super(size);
        }

        @Override
        protected int getMaxSize() {
            return IndexSearcher.getMaxClauseCount();
        }

        @Override
        protected BooleanQuery.Builder getTopLevelBuilder() {
            return new BooleanQuery.Builder();
        }

        @Override
        protected Query build(BooleanQuery.Builder builder) {
            return builder.build();
        }

        @Override
        protected void addClause(BooleanQuery.Builder topLevel, Term term, int docFreq, float boost, TermStates states) {
            ConstantScoreQuery q = new ConstantScoreQuery(new TermQuery(term, states));
            topLevel.add(new BoostQuery(q, boost), BooleanClause.Occur.SHOULD);
        }
    }

    public static final class TopTermsBlendedFreqScoringRewrite
    extends TopTermsRewrite<BlendedTermQuery.Builder> {
        public TopTermsBlendedFreqScoringRewrite(int size) {
            super(size);
        }

        @Override
        protected int getMaxSize() {
            return IndexSearcher.getMaxClauseCount();
        }

        @Override
        protected BlendedTermQuery.Builder getTopLevelBuilder() {
            BlendedTermQuery.Builder builder = new BlendedTermQuery.Builder();
            builder.setRewriteMethod(BlendedTermQuery.BOOLEAN_REWRITE);
            return builder;
        }

        @Override
        protected Query build(BlendedTermQuery.Builder builder) {
            return builder.build();
        }

        @Override
        protected void addClause(BlendedTermQuery.Builder topLevel, Term term, int docCount, float boost, TermStates states) {
            topLevel.add(term, boost, states);
        }
    }

    public static final class TopTermsScoringBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery.Builder> {
        public TopTermsScoringBooleanQueryRewrite(int size) {
            super(size);
        }

        @Override
        protected int getMaxSize() {
            return IndexSearcher.getMaxClauseCount();
        }

        @Override
        protected BooleanQuery.Builder getTopLevelBuilder() {
            return new BooleanQuery.Builder();
        }

        @Override
        protected Query build(BooleanQuery.Builder builder) {
            return builder.build();
        }

        @Override
        protected void addClause(BooleanQuery.Builder topLevel, Term term, int docCount, float boost, TermStates states) {
            TermQuery tq = new TermQuery(term, states);
            topLevel.add(new BoostQuery(tq, boost), BooleanClause.Occur.SHOULD);
        }
    }

    public static abstract class RewriteMethod {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;

        protected TermsEnum getTermsEnum(MultiTermQuery query, Terms terms, AttributeSource atts) throws IOException {
            return query.getTermsEnum(terms, atts);
        }
    }
}

