/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.util.ArrayList;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.search.AutomatonQuery;
import org.neo4j.shaded.lucene9.search.MultiTermQuery;
import org.neo4j.shaded.lucene9.util.automaton.Automata;
import org.neo4j.shaded.lucene9.util.automaton.Automaton;
import org.neo4j.shaded.lucene9.util.automaton.Operations;

public class WildcardQuery
extends AutomatonQuery {
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';
    public static final char WILDCARD_ESCAPE = '\\';

    public WildcardQuery(Term term) {
        super(term, WildcardQuery.toAutomaton(term));
    }

    public WildcardQuery(Term term, int determinizeWorkLimit) {
        this(term, determinizeWorkLimit, CONSTANT_SCORE_BLENDED_REWRITE);
    }

    public WildcardQuery(Term term, int determinizeWorkLimit, MultiTermQuery.RewriteMethod rewriteMethod) {
        super(term, WildcardQuery.toAutomaton(term), determinizeWorkLimit, false, rewriteMethod);
    }

    public static Automaton toAutomaton(Term wildcardquery) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        String wildcardText = wildcardquery.text();
        block5: for (int i = 0; i < wildcardText.length(); i += length) {
            int c = wildcardText.codePointAt(i);
            length = Character.charCount(c);
            switch (c) {
                case 42: {
                    automata.add(Automata.makeAnyString());
                    continue block5;
                }
                case 63: {
                    automata.add(Automata.makeAnyChar());
                    continue block5;
                }
                case 92: {
                    if (i + length < wildcardText.length()) {
                        int nextChar = wildcardText.codePointAt(i + length);
                        length += Character.charCount(nextChar);
                        automata.add(Automata.makeChar(nextChar));
                        continue block5;
                    }
                }
                default: {
                    automata.add(Automata.makeChar(c));
                }
            }
        }
        return Operations.concatenate(automata);
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        return buffer.toString();
    }
}

