/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.store;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.FilterDirectory;
import org.neo4j.shaded.lucene9.store.IOContext;
import org.neo4j.shaded.lucene9.store.IndexOutput;
import org.neo4j.shaded.lucene9.store.Lock;

public final class LockValidatingDirectoryWrapper
extends FilterDirectory {
    private final Lock writeLock;

    public LockValidatingDirectoryWrapper(Directory in, Lock writeLock) {
        super(in);
        this.writeLock = writeLock;
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.writeLock.ensureValid();
        this.in.deleteFile(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.writeLock.ensureValid();
        return this.in.createOutput(name, context);
    }

    @Override
    public void copyFrom(Directory from, String src, String dest, IOContext context) throws IOException {
        this.writeLock.ensureValid();
        this.in.copyFrom(from, src, dest, context);
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.writeLock.ensureValid();
        this.in.rename(source, dest);
    }

    @Override
    public void syncMetaData() throws IOException {
        this.writeLock.ensureValid();
        this.in.syncMetaData();
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.writeLock.ensureValid();
        this.in.sync(names);
    }
}

