/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.util.hnsw;

import java.util.concurrent.locks.ReentrantLock;

public final class BlockingFloatHeap {
    private final int maxSize;
    private final float[] heap;
    private final ReentrantLock lock;
    private int size;

    public BlockingFloatHeap(int maxSize) {
        this.maxSize = maxSize;
        this.heap = new float[maxSize + 1];
        this.lock = new ReentrantLock();
        this.size = 0;
    }

    public float offer(float value) {
        this.lock.lock();
        try {
            if (this.size < this.maxSize) {
                this.push(value);
                float f = this.heap[1];
                return f;
            }
            if (value >= this.heap[1]) {
                this.updateTop(value);
            }
            float f = this.heap[1];
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float offer(float[] values, int len) {
        this.lock.lock();
        try {
            for (int i = len - 1; i >= 0; --i) {
                if (this.size < this.maxSize) {
                    this.push(values[i]);
                    continue;
                }
                if (!(values[i] >= this.heap[1])) break;
                this.updateTop(values[i]);
            }
            float f = this.heap[1];
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    public float poll() {
        if (this.size > 0) {
            float result;
            this.lock.lock();
            try {
                result = this.heap[1];
                this.heap[1] = this.heap[this.size];
                --this.size;
                this.downHeap(1);
            }
            finally {
                this.lock.unlock();
            }
            return result;
        }
        throw new IllegalStateException("The heap is empty");
    }

    public float peek() {
        this.lock.lock();
        try {
            float f = this.heap[1];
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void push(float element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap(this.size);
    }

    private float updateTop(float value) {
        this.heap[1] = value;
        this.downHeap(1);
        return this.heap[1];
    }

    private void downHeap(int i) {
        float value = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.heap[k] < this.heap[j]) {
            j = k;
        }
        while (j <= this.size && this.heap[j] < value) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !(this.heap[k] < this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = value;
    }

    private void upHeap(int origPos) {
        int i = origPos;
        float value = this.heap[i];
        for (int j = i >>> 1; j > 0 && value < this.heap[j]; j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = value;
    }
}

