/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.SSLEngine;
import org.neo4j.ssl.ClientSideHostnameVerificationEngineModification;
import org.neo4j.ssl.EssentialEngineModifications;
import org.neo4j.ssl.SslHandlerDetailsRegisteredEvent;

public class ClientSideOnConnectSslHandler
extends ChannelDuplexHandler {
    private final ChannelPipeline pipeline;
    private final SslContext sslContext;
    private final Collection<Function<SSLEngine, SSLEngine>> engineModifications;

    ClientSideOnConnectSslHandler(Channel channel, SslContext sslContext, boolean verifyHostname, String[] tlsVersions) {
        this.pipeline = channel.pipeline();
        this.sslContext = sslContext;
        this.engineModifications = new ArrayList<Function<SSLEngine, SSLEngine>>();
        this.engineModifications.add(new EssentialEngineModifications(tlsVersions, true));
        if (verifyHostname) {
            this.engineModifications.add(new ClientSideHostnameVerificationEngineModification());
        }
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        SslHandler sslHandler = this.createSslHandler(ctx, (InetSocketAddress)remoteAddress);
        this.replaceSelfWith(sslHandler);
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            SslHandler sslHandler = this.createSslHandler(ctx, (InetSocketAddress)ctx.channel().remoteAddress());
            this.replaceSelfWith(sslHandler);
            sslHandler.handlerAdded(ctx);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        throw new RuntimeException(Thread.currentThread().getName() + " - This handler does not write");
    }

    private void replaceSelfWith(SslHandler sslHandler) {
        String myName = this.pipeline.toMap().entrySet().stream().filter(entry -> ((Object)((Object)this)).equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalStateException("This handler has no name"));
        this.pipeline.replace((ChannelHandler)this, myName, (ChannelHandler)sslHandler);
        this.pipeline.addAfter(myName, "handshakeCompletionSslDetailsHandler", (ChannelHandler)new HandshakeCompletionSslDetailsHandler());
    }

    private SslHandler createSslHandler(ChannelHandlerContext ctx, InetSocketAddress inetSocketAddress) {
        SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc(), inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        for (Function<SSLEngine, SSLEngine> mod : this.engineModifications) {
            sslEngine = mod.apply(sslEngine);
        }
        return new SslHandler(sslEngine);
    }

    private static class HandshakeCompletionSslDetailsHandler
    extends ChannelInboundHandlerAdapter {
        private HandshakeCompletionSslDetailsHandler() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            SslHandshakeCompletionEvent sslHandshakeEvent;
            if (evt instanceof SslHandshakeCompletionEvent && (sslHandshakeEvent = (SslHandshakeCompletionEvent)evt).cause() == null) {
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                String ciphers = sslHandler.engine().getSession().getCipherSuite();
                String protocols = sslHandler.engine().getSession().getProtocol();
                ctx.fireUserEventTriggered((Object)new SslHandlerDetailsRegisteredEvent(ciphers, protocols));
            }
            ctx.fireUserEventTriggered(evt);
        }
    }
}

