/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.PreferHeapByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.ssl.ClientSideOnConnectSslHandler;

public class SslPolicy {
    private final PrivateKey privateKey;
    private final X509Certificate[] keyCertChain;
    private final List<String> ciphers;
    private final String[] tlsVersions;
    private final ClientAuth clientAuth;
    private final Path privateKeyFile;
    private final Path certificateFile;
    private final TrustManagerFactory trustManagerFactory;
    private final SslProvider sslProvider;
    private final boolean verifyHostname;
    private final boolean verifyExpiration;
    private final InternalLog log;

    public SslPolicy(PrivateKey privateKey, Path privateKeyFile, X509Certificate[] keyCertChain, Path certificateFile, List<String> tlsVersions, List<String> ciphers, ClientAuth clientAuth, TrustManagerFactory trustManagerFactory, SslProvider sslProvider, boolean verifyHostname, boolean verifyExpiration, InternalLogProvider logProvider) {
        this.privateKey = privateKey;
        this.keyCertChain = keyCertChain;
        this.tlsVersions = tlsVersions == null ? null : tlsVersions.toArray(new String[0]);
        this.clientAuth = clientAuth;
        this.trustManagerFactory = trustManagerFactory;
        this.sslProvider = sslProvider;
        this.verifyHostname = verifyHostname;
        this.verifyExpiration = verifyExpiration;
        this.log = logProvider.getLog(SslPolicy.class);
        this.privateKeyFile = privateKeyFile;
        this.certificateFile = certificateFile;
        List<String> filteredCiphers = this.removeInsecureCiphersFromDefaults(ciphers);
        this.ciphers = filteredCiphers;
    }

    private List<String> removeInsecureCiphersFromDefaults(List<String> ciphers) {
        if (ciphers == null) {
            try {
                SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(this.sslProvider).keyManager(this.privateKey, this.keyCertChain).protocols(this.tlsVersions).ciphers(ciphers).trustManager(this.trustManagerFactory);
                SslContext context = builder.build();
                ByteBufAllocator alloc = PreferHeapByteBufAllocator.DEFAULT;
                SSLEngine engine = context.newEngine(alloc);
                String[] enabledCiphers = engine.getEnabledCipherSuites();
                List<String> filteredCiphers = Arrays.stream(enabledCiphers).filter(cipher -> !cipher.contains("_CBC_")).toList();
                ciphers = filteredCiphers;
            }
            catch (SSLException e) {
                this.log.warn("Exception interrogating default enabled cipher suites", (Throwable)e);
            }
        }
        return ciphers;
    }

    public SslContext nettyServerContext() throws SSLException {
        return SslContextBuilder.forServer((PrivateKey)this.privateKey, (X509Certificate[])this.keyCertChain).sslProvider(this.sslProvider).clientAuth(SslPolicy.forNetty(this.clientAuth)).protocols(this.tlsVersions).ciphers(this.ciphers).trustManager(this.trustManagerFactory).build();
    }

    public SslContext nettyClientContext() throws SSLException {
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(this.sslProvider).keyManager(this.privateKey, this.keyCertChain).protocols(this.tlsVersions).ciphers(this.ciphers).trustManager(this.trustManagerFactory);
        if (!this.verifyHostname) {
            builder.endpointIdentificationAlgorithm(null);
        }
        return builder.build();
    }

    private static io.netty.handler.ssl.ClientAuth forNetty(ClientAuth clientAuth) {
        return switch (clientAuth) {
            default -> throw new MatchException(null, null);
            case ClientAuth.NONE -> io.netty.handler.ssl.ClientAuth.NONE;
            case ClientAuth.OPTIONAL -> io.netty.handler.ssl.ClientAuth.OPTIONAL;
            case ClientAuth.REQUIRE -> io.netty.handler.ssl.ClientAuth.REQUIRE;
        };
    }

    public ChannelHandler nettyServerHandler(Channel channel) throws SSLException {
        return SslPolicy.nettyServerHandler(channel, this.nettyServerContext());
    }

    private static ChannelHandler nettyServerHandler(Channel channel, SslContext sslContext) {
        SSLEngine sslEngine = sslContext.newEngine(channel.alloc());
        return new SslHandler(sslEngine);
    }

    public ChannelHandler nettyClientHandler(Channel channel) throws SSLException {
        return this.nettyClientHandler(channel, this.nettyClientContext());
    }

    public ChannelHandler nettyClientHandler(Channel channel, SslContext sslContext) {
        return new ClientSideOnConnectSslHandler(channel, sslContext, this.verifyHostname, this.tlsVersions);
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public X509Certificate[] certificateChain() {
        return this.keyCertChain;
    }

    public Path certificateFile() {
        return this.certificateFile;
    }

    public Path privateKeyFile() {
        return this.privateKeyFile;
    }

    public KeyStore getKeyStore(char[] keyStorePass, char[] privateKeyPass) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.log.debug("Keystore loaded is of type " + keyStore.getClass().getName());
            keyStore.load(null, keyStorePass);
            keyStore.setKeyEntry("key", this.privateKey, privateKeyPass, this.keyCertChain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return keyStore;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public List<String> getCipherSuites() {
        return this.ciphers;
    }

    public String[] getTlsVersions() {
        return this.tlsVersions;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public boolean shouldVerifyExpiration() {
        return this.verifyExpiration;
    }

    public String toString() {
        return "SslPolicy{keyCertChain=" + this.describeCertChain() + ", ciphers=" + String.valueOf(this.ciphers) + ", tlsVersions=" + Arrays.toString(this.tlsVersions) + ", clientAuth=" + String.valueOf(this.clientAuth) + "}";
    }

    private static String describeCertificate(X509Certificate certificate) {
        return "Subject: " + String.valueOf(certificate.getSubjectDN()) + ", Issuer: " + String.valueOf(certificate.getIssuerDN());
    }

    private String describeCertChain() {
        List certificates = Arrays.stream(this.keyCertChain).map(SslPolicy::describeCertificate).collect(Collectors.toList());
        return String.join((CharSequence)", ", certificates);
    }
}

