/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Comparison;
import org.neo4j.cypherdsl.core.CompoundCondition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.internal.RelationshipPatternCondition;

@API(status=API.Status.STABLE, since="1.0")
public interface Condition
extends Expression {
    default public Condition and(Condition condition) {
        return CompoundCondition.create(this, Operator.AND, condition);
    }

    default public Condition or(Condition condition) {
        return CompoundCondition.create(this, Operator.OR, condition);
    }

    default public Condition xor(Condition condition) {
        return CompoundCondition.create(this, Operator.XOR, condition);
    }

    default public Condition and(RelationshipPattern pathPattern) {
        return CompoundCondition.create(this, Operator.AND, RelationshipPatternCondition.of(pathPattern));
    }

    default public Condition or(RelationshipPattern pathPattern) {
        return CompoundCondition.create(this, Operator.OR, RelationshipPatternCondition.of(pathPattern));
    }

    default public Condition xor(RelationshipPattern pathPattern) {
        return CompoundCondition.create(this, Operator.XOR, RelationshipPatternCondition.of(pathPattern));
    }

    default public Condition not() {
        return Comparison.create(Operator.NOT, this);
    }
}

