/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.Map;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;

class DataCollectorOptions {
    private DataCollectorOptions() {
    }

    static class IntOption
    extends Option<Integer> {
        IntOption(String name, int defaultValue) {
            super(name, defaultValue);
        }

        @Override
        Integer parse(Object value) throws InvalidArgumentsException {
            int x = this.asInteger(value);
            if (x < 0) {
                throw InvalidArgumentsException.requiresPositiveIntegerInOptions((String)this.name, (int)x);
            }
            return x;
        }

        private int asInteger(Object value) throws InvalidArgumentsException {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                return ((Number)value).intValue();
            }
            throw InvalidArgumentsException.optionRequiresInteger((String)this.name, (Object)value);
        }
    }

    static abstract class Option<T> {
        final String name;
        final T defaultValue;

        Option(String name, T defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        abstract T parse(Object var1) throws InvalidArgumentsException;

        T parseOrDefault(Map<String, Object> valueMap) throws InvalidArgumentsException {
            if (valueMap.containsKey(this.name)) {
                Object o = valueMap.get(this.name);
                return this.parse(o);
            }
            return this.defaultValue;
        }
    }
}

