/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.function.Consumer;
import org.neo4j.internal.collector.RingRecentBuffer;
import org.neo4j.internal.collector.TruncatedQuerySnapshot;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class RecentQueryBuffer {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RecentQueryBuffer.class);
    private final RingRecentBuffer<TruncatedQuerySnapshot> queries;
    private final MemoryTracker memoryTracker;
    private final int bufferSize;

    public RecentQueryBuffer(int maxRecentQueryCount, MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
        this.bufferSize = Integer.highestOneBit(maxRecentQueryCount);
        this.queries = new RingRecentBuffer<TruncatedQuerySnapshot>(this.bufferSize, discarded -> memoryTracker.releaseHeap(discarded.estimatedHeap));
        if (this.bufferSize > 0) {
            memoryTracker.allocateHeap(this.queries.estimatedHeapUsage() + SHALLOW_SIZE);
        }
    }

    public long numSilentQueryDrops() {
        return this.queries.numSilentQueryDrops();
    }

    public void produce(TruncatedQuerySnapshot query) {
        Preconditions.checkArgument((query.databaseId != null ? 1 : 0) != 0, (String)"Only queries targeting a specific database are expected in the recent query buffer.");
        if (this.bufferSize == 0) {
            return;
        }
        this.memoryTracker.allocateHeap(query.estimatedHeap);
        this.queries.produce(query);
    }

    public void clear(NamedDatabaseId databaseId) {
        Preconditions.checkArgument((databaseId != null ? 1 : 0) != 0, (String)"Only queries targeting a specific database are expected in the recent query buffer, clearing non-database queries will have no effect.");
        this.queries.clearIf(q -> databaseId.equals((Object)q.databaseId));
    }

    public void foreach(NamedDatabaseId databaseId, Consumer<TruncatedQuerySnapshot> consumer) {
        this.queries.foreach(q -> {
            if (q.databaseId.equals((Object)databaseId)) {
                consumer.accept((TruncatedQuerySnapshot)q);
            }
        });
    }
}

