/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.neo4j.internal.collector.RecentBuffer;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;

public class RingRecentBuffer<T>
implements RecentBuffer<T> {
    private static final long CONSUMER_SIZE = HeapEstimator.alignObjectSize((long)(HeapEstimator.OBJECT_HEADER_BYTES + HeapEstimator.OBJECT_REFERENCE_BYTES));
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RingRecentBuffer.class) + 2L * HeapEstimator.shallowSizeOfInstance(AtomicLong.class) + CONSUMER_SIZE;
    private static final long VOLATILE_REF_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(VolatileRef.class);
    private final int size;
    private final int mask;
    private final VolatileRef<T>[] data;
    private final AtomicLong produceCount;
    private final AtomicLong dropEvents;
    private final Consumer<T> onDiscard;

    public RingRecentBuffer(int size, Consumer<T> onDiscard) {
        if (size > 0) {
            Preconditions.requirePowerOfTwo((long)size);
        }
        this.onDiscard = onDiscard;
        this.size = size;
        this.mask = size - 1;
        this.data = new VolatileRef[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = new VolatileRef();
            this.data[i].produceNumber = i - size;
        }
        this.produceCount = new AtomicLong(0L);
        this.dropEvents = new AtomicLong(0L);
    }

    long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.shallowSizeOf((Object[])this.data) + (long)this.data.length * VOLATILE_REF_SHALLOW_SIZE;
    }

    long numSilentQueryDrops() {
        return this.dropEvents.get();
    }

    @Override
    public void produce(T t) {
        int offset;
        VolatileRef<T> volatileRef;
        if (this.size == 0) {
            return;
        }
        long produceNumber = this.produceCount.getAndIncrement();
        if (this.assertPreviousCompleted(produceNumber, volatileRef = this.data[offset = (int)(produceNumber & (long)this.mask)])) {
            Object discarded = volatileRef.ref;
            if (discarded != null) {
                this.onDiscard.accept(discarded);
            }
            volatileRef.ref = t;
            volatileRef.produceNumber = produceNumber;
        } else {
            this.onDiscard.accept(t);
            this.dropEvents.incrementAndGet();
        }
    }

    private boolean assertPreviousCompleted(long produceNumber, VolatileRef<T> volatileRef) {
        int attempts;
        long prevProduceNumber = volatileRef.produceNumber;
        for (attempts = 100; prevProduceNumber != produceNumber - (long)this.size && attempts > 0; --attempts) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            prevProduceNumber = volatileRef.produceNumber;
        }
        return attempts > 0;
    }

    @Override
    public void clearIf(Predicate<T> predicate) {
        if (this.size == 0) {
            return;
        }
        for (VolatileRef<T> volatileRef : this.data) {
            Object data = volatileRef.ref;
            if (data == null || !predicate.test(data)) continue;
            this.onDiscard.accept(data);
            volatileRef.ref = null;
        }
    }

    @Override
    public void foreach(Consumer<T> consumer) {
        long snapshotConsume;
        if (this.size == 0) {
            return;
        }
        long snapshotProduce = this.produceCount.get();
        for (long i = snapshotConsume = Math.max(0L, snapshotProduce - (long)this.size); i < snapshotProduce; ++i) {
            int offset = (int)(i & (long)this.mask);
            VolatileRef<T> volatileRef = this.data[offset];
            if (volatileRef.produceNumber < i) {
                return;
            }
            Object data = volatileRef.ref;
            if (data == null) continue;
            consumer.accept(data);
        }
    }

    private static class VolatileRef<T> {
        private volatile T ref;
        private volatile long produceNumber;

        private VolatileRef() {
        }
    }
}

