/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.ConfigFileMigrator;
import org.neo4j.server.startup.EnhancedExecutionContext;
import picocli.CommandLine;

@CommandLine.Command(name="migrate-configuration", header={"Migrate server configuration from the previous major version."}, description={"Migrate legacy configuration located in source configuration directory to the current format. The new version will be written in a target configuration directory. The default location for both the source and target configuration directory is the configuration directory specified by NEO_CONF or the default configuration directory for this installation. If the source and target directories are the same, the original configuration files will be renamed. Configuration provided using --additional-config option is not migrated."})
public class MigrateConfigCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--from-path"}, paramLabel="<path>", description={"Path to the configuration directory used as a source for the migration."})
    private Path fromPath;
    @CommandLine.Option(names={"--to-path"}, paramLabel="<path>", description={"Path to a directory where the migrated configuration files should be written."})
    private Path toPath;

    public MigrateConfigCommand(ExecutionContext ctx) {
        super(ctx);
    }

    protected void execute() throws Exception {
        Path sourceFile = this.configFile(this.fromPath);
        if (!Files.isRegularFile(sourceFile, new LinkOption[0])) {
            throw new CommandFailedException(String.format("Resolved source file '%s' does not exist", sourceFile));
        }
        Path targetFile = this.configFile(this.toPath);
        if (!Files.isDirectory(targetFile.getParent(), new LinkOption[0])) {
            throw new CommandFailedException(String.format("Target path '%s' is not an existing directory", targetFile.getParent()));
        }
        EnhancedExecutionContext enhancedCtx = EnhancedExecutionContext.unwrapFromExecutionContext(this.ctx);
        ConfigFileMigrator migrator = new ConfigFileMigrator(this.ctx.out(), this.ctx.err(), enhancedCtx.getClassloaderWithPlugins());
        migrator.migrate(sourceFile, targetFile);
    }

    private Path configFile(Path providedConfigDir) {
        if (providedConfigDir == null) {
            providedConfigDir = this.ctx.confDir();
        } else if (!Files.isDirectory(providedConfigDir, new LinkOption[0])) {
            throw new CommandFailedException(String.format("Provided path '%s' is not an existing directory", providedConfigDir));
        }
        return providedConfigDir.resolve("neo4j.conf");
    }
}

