/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.dbms.CommunityDatabaseState;
import org.neo4j.dbms.DatabaseState;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.kernel.database.NamedDatabaseId;

public final class CommunityDatabaseStateService
implements DatabaseStateService {
    private final DatabaseContextProvider<StandaloneDatabaseContext> databaseContextProvider;

    public CommunityDatabaseStateService(DatabaseContextProvider<StandaloneDatabaseContext> databaseContextProvider) {
        this.databaseContextProvider = databaseContextProvider;
    }

    public Map<NamedDatabaseId, DatabaseState> stateOfAllDatabases() {
        return this.databaseContextProvider.registeredDatabases().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> CommunityDatabaseStateService.getState((StandaloneDatabaseContext)entry.getValue())));
    }

    public DatabaseState stateOfDatabase(NamedDatabaseId namedDatabaseId) {
        return this.databaseContextProvider.getDatabaseContext(namedDatabaseId).map(CommunityDatabaseStateService::getState).orElse(CommunityDatabaseState.unknown(namedDatabaseId));
    }

    public Optional<Throwable> causeOfFailure(NamedDatabaseId namedDatabaseId) {
        return this.databaseContextProvider.getDatabaseContext(namedDatabaseId).map(StandaloneDatabaseContext::failureCause);
    }

    private static DatabaseState getState(StandaloneDatabaseContext ctx) {
        return new CommunityDatabaseState(ctx.database().getNamedDatabaseId(), ctx.database().isStarted(), ctx.isFailed(), ctx.failureCause());
    }
}

