/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.api;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.Edition;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.Neo4jDatabaseManagementServiceBuilder;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.logging.ExternalLogProviderWrapper;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.service.Services;

public class DatabaseManagementServiceBuilderImplementation
implements Neo4jDatabaseManagementServiceBuilder {
    protected final List<ExtensionFactory<?>> extensions = new ArrayList();
    protected final List<DatabaseEventListener> databaseEventListeners = new ArrayList<DatabaseEventListener>();
    protected Monitors monitors;
    private InternalLogProvider userLogProvider = NullLogProvider.getInstance();
    protected DependencyResolver dependencies = new Dependencies();
    protected Path homeDirectory;
    protected Config.Builder config = Config.newBuilder();
    protected boolean daemonMode;

    public DatabaseManagementServiceBuilderImplementation(Path homeDirectory, Predicate<Class<? extends ExtensionFactory>> extensionFilter) {
        this.homeDirectory = homeDirectory;
        Services.loadAll(ExtensionFactory.class).stream().filter(e -> extensionFilter.test(e.getClass())).forEach(this.extensions::add);
    }

    public DatabaseManagementServiceBuilderImplementation(Path homeDirectory) {
        this(homeDirectory, extension -> true);
    }

    @Override
    public DatabaseManagementService build() {
        this.config.set(GraphDatabaseSettings.neo4j_home, (Object)this.homeDirectory.toAbsolutePath());
        return this.newDatabaseManagementService(this.config.build(), this.databaseDependencies());
    }

    protected DatabaseManagementService newDatabaseManagementService(Config config, ExternalDependencies dependencies) {
        return new DatabaseManagementServiceFactory(this.getDbmsInfo(config), this.getEditionFactory(config)).build(this.augmentConfig(config), this.daemonMode, dependencies);
    }

    protected DbmsInfo getDbmsInfo(Config config) {
        return DbmsInfo.COMMUNITY;
    }

    protected Function<GlobalModule, AbstractEditionModule> getEditionFactory(Config config) {
        return CommunityEditionModule::new;
    }

    protected Config augmentConfig(Config config) {
        return config;
    }

    @Override
    public DatabaseManagementServiceBuilderImplementation addDatabaseListener(DatabaseEventListener databaseEventListener) {
        this.databaseEventListeners.add(databaseEventListener);
        return this;
    }

    @Override
    public DatabaseManagementServiceBuilderImplementation setUserLogProvider(LogProvider userLogProvider) {
        InternalLogProvider internalLogProvider;
        this.userLogProvider = userLogProvider instanceof InternalLogProvider ? (internalLogProvider = (InternalLogProvider)userLogProvider) : new ExternalLogProviderWrapper(userLogProvider);
        return this;
    }

    public DatabaseManagementServiceBuilderImplementation setMonitors(Monitors monitors) {
        this.monitors = monitors;
        return this;
    }

    public DatabaseManagementServiceBuilderImplementation setExternalDependencies(DependencyResolver dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public String getEdition() {
        return Edition.COMMUNITY.toString();
    }

    protected ExternalDependencies databaseDependencies() {
        return GraphDatabaseDependencies.newDependencies().monitors(this.monitors).userLogProvider(this.userLogProvider).dependencies(this.dependencies).extensions(this.extensions).databaseEventListeners(this.databaseEventListeners);
    }

    @Override
    public <T> DatabaseManagementServiceBuilderImplementation setConfig(Setting<T> setting, T value) {
        if (value == null) {
            this.config.remove(setting);
        } else {
            this.config.set(setting, value);
        }
        return this;
    }

    @Override
    public DatabaseManagementServiceBuilderImplementation setConfig(Map<Setting<?>, Object> config) {
        this.config.set(config);
        return this;
    }

    public DatabaseManagementServiceBuilderImplementation setConfigRaw(Map<String, String> raw) {
        this.config.setRaw(raw);
        return this;
    }

    @Override
    public DatabaseManagementServiceBuilderImplementation loadPropertiesFromFile(Path path) {
        try {
            this.config.fromFileNoThrow(path);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load " + String.valueOf(path), e);
        }
        return this;
    }
}

