/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.DatabaseContextFactory;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.DefaultPropertyTokenCreator;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.token.CreatingTokenHolder;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public abstract class AbstractDatabaseContextFactory<CONTEXT, OPTIONS>
implements DatabaseContextFactory<CONTEXT, OPTIONS> {
    protected final GlobalModule globalModule;
    protected final IdContextFactory idContextFactory;

    public AbstractDatabaseContextFactory(GlobalModule globalModule, IdContextFactory idContextFactory) {
        this.globalModule = globalModule;
        this.idContextFactory = idContextFactory;
    }

    public static TokenHolders createTokenHolderProvider(Supplier<Kernel> kernelSupplier) {
        return new TokenHolders((TokenHolder)new CreatingTokenHolder(AbstractDatabaseContextFactory.createPropertyKeyCreator(kernelSupplier), "PropertyKey"), (TokenHolder)new CreatingTokenHolder(AbstractDatabaseContextFactory.createLabelIdCreator(kernelSupplier), "Label"), (TokenHolder)new CreatingTokenHolder(AbstractDatabaseContextFactory.createRelationshipTypeCreator(kernelSupplier), "RelationshipType"));
    }

    protected static TokenCreator createRelationshipTypeCreator(Supplier<Kernel> kernelSupplier) {
        return new DefaultRelationshipTypeCreator(kernelSupplier);
    }

    protected static TokenCreator createPropertyKeyCreator(Supplier<Kernel> kernelSupplier) {
        return new DefaultPropertyTokenCreator(kernelSupplier);
    }

    protected static TokenCreator createLabelIdCreator(Supplier<Kernel> kernelSupplier) {
        return new DefaultLabelIdCreator(kernelSupplier);
    }

    protected final CursorContextFactory createContextFactory(DatabaseConfig databaseConfig, NamedDatabaseId databaseId) {
        PageCacheTracer pageCacheTracer = this.globalModule.getTracers().getPageCacheTracer();
        VersionContextSupplier.Factory factory = AbstractDatabaseContextFactory.externalVersionContextSupplierFactory(this.globalModule).orElse(AbstractDatabaseContextFactory.internalVersionContextSupplierFactory(databaseConfig));
        return new CursorContextFactory(pageCacheTracer, factory.create(databaseId));
    }

    private static Optional<VersionContextSupplier.Factory> externalVersionContextSupplierFactory(GlobalModule globalModule) {
        DependencyResolver externalDependencies = globalModule.getExternalDependencyResolver();
        return externalDependencies.resolveOptionalDependency(VersionContextSupplier.Factory.class);
    }

    private static VersionContextSupplier.Factory internalVersionContextSupplierFactory(DatabaseConfig databaseConfig) {
        String formatString = (String)databaseConfig.get(GraphDatabaseSettings.db_format);
        return databaseId -> ((String)databaseConfig.get(GraphDatabaseSettings.db_format)).contains("multiversion") || (Boolean)databaseConfig.get(GraphDatabaseInternalSettings.snapshot_query) != false ? new TransactionVersionContextSupplier() : FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER;
    }
}

