/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph.versions;

import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphVersion;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.versions.KnownCommunityTopologyComponentVersion;
import org.neo4j.graphdb.Transaction;
import org.neo4j.util.Stringifier;

public class CommunityTopologyComponentVersion_3_202502
extends KnownCommunityTopologyComponentVersion {
    private final KnownCommunityTopologyComponentVersion previous;

    public CommunityTopologyComponentVersion_3_202502(KnownCommunityTopologyComponentVersion previous) {
        super(CommunityTopologyGraphVersion.COMMUNITY_TOPOLOGY_202502);
        this.previous = previous;
    }

    @Override
    public void upgradeTopologyGraph(Transaction tx, int fromVersion) throws Exception {
        if (fromVersion < this.version) {
            this.previous.upgradeTopologyGraph(tx, fromVersion);
            this.setVersionProperty(tx, this.version);
            this.addDisplayPropToDatabaseName(tx);
            this.addDefaultLanguageToDatabase(tx);
        }
    }

    private void addDisplayPropToDatabaseName(Transaction tx) {
        tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL).stream().filter(node -> node.getProperty("quotedDisplayName", null) == null).forEach(node -> {
            String name = (String)node.getProperty("name");
            String namespace = (String)node.getProperty("namespace", (Object)"system-root");
            String backtickedName = Stringifier.backtick((String)name);
            String displayName = namespace.equals("system-root") ? backtickedName : Stringifier.backtick((String)namespace) + "." + backtickedName;
            node.setProperty("quotedDisplayName", (Object)displayName);
        });
    }

    private void addDefaultLanguageToDatabase(Transaction tx) {
        tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL).stream().filter(node -> node.getProperty("defaultLanguage", null) == null).forEach(node -> node.setProperty("defaultLanguage", (Object)CypherVersion.Cypher5.persistedValue));
    }
}

