/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph.versions;

import java.util.Iterator;
import java.util.stream.Stream;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersion;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public abstract class KnownCommunityTopologyComponentVersion
extends KnownSystemComponentVersion {
    KnownCommunityTopologyComponentVersion(ComponentVersion componentVersion) {
        super(componentVersion, (Log)NullLog.getInstance());
    }

    public void initializeTopologyGraph(Transaction tx) {
        this.setDatabaseAccessToReadWrite(tx);
        this.addDatabaseNameNodes(tx);
    }

    protected void setDatabaseAccessToReadWrite(Transaction tx) {
        String rwString = TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString();
        Iterators.forEachRemaining((Iterator)tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL), node -> node.setProperty("access", (Object)rwString));
    }

    protected void addDatabaseNameNodes(Transaction tx) {
        Iterators.forEachRemaining((Iterator)tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL), databaseNode -> {
            if (!this.hasPrimaryAlias((Node)databaseNode)) {
                Node nameNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_NAME_LABEL});
                nameNode.setProperty("name", databaseNode.getProperty("name"));
                nameNode.setProperty("primary", (Object)true);
                nameNode.createRelationshipTo(databaseNode, TopologyGraphDbmsModel.TARGETS_RELATIONSHIP);
            }
        });
    }

    private boolean hasPrimaryAlias(Node node) {
        try (Stream targets = node.getRelationships(new RelationshipType[]{TopologyGraphDbmsModel.TARGETS_RELATIONSHIP}).stream();){
            boolean bl = targets.anyMatch(r -> r.getStartNode().getProperty("primary").equals(true));
            return bl;
        }
    }

    public abstract void upgradeTopologyGraph(Transaction var1, int var2) throws Exception;
}

