/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import java.util.function.Function;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.systemgraph.ContextBasedSystemDatabaseProvider;
import org.neo4j.dbms.systemgraph.SystemDatabaseProvider;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;

public class SystemDatabaseRunner
implements Resource {
    private final EditionModuleFactory editionFactory;
    private final Config config;
    private final InternalLogProvider systemDbStartupLogProvider;
    private final FileSystemAbstraction fs;
    private GlobalModule globalModule;
    private GraphDatabaseAPI systemDatabase;

    public SystemDatabaseRunner(FileSystemAbstraction fs, EditionModuleFactory editionFactory, Config config, InternalLogProvider systemDbStartupLogProvider) {
        this.fs = fs;
        this.editionFactory = editionFactory;
        this.config = config;
        this.systemDbStartupLogProvider = systemDbStartupLogProvider;
    }

    public SystemDatabaseRunner run() throws Exception {
        if (this.globalModule != null) {
            throw new IllegalStateException("System database runner already running");
        }
        GraphDatabaseDependencies graphDatabaseDependencies = GraphDatabaseDependencies.newDependencies().extensions(Iterables.empty()).dependencies((DependencyResolver)Dependencies.dependenciesOf((Object)this.fs));
        this.globalModule = new GlobalModule(this.config, DbmsInfo.TOOL, false, graphDatabaseDependencies){

            @Override
            protected LogService createLogService(InternalLogProvider userLogProvider, boolean daemonMode) {
                return new SimpleLogService(SystemDatabaseRunner.this.systemDbStartupLogProvider);
            }

            @Override
            protected GlobalTransactionEventListeners createGlobalTransactionEventListeners() {
                return GlobalTransactionEventListeners.NULL;
            }
        };
        LifeSupport globalLife = this.globalModule.getGlobalLife();
        try {
            AbstractEditionModule edition = (AbstractEditionModule)this.editionFactory.apply(this.globalModule);
            Dependencies globalDependencies = this.globalModule.getGlobalDependencies();
            this.globalModule.getGlobalDependencies().satisfyDependency((Object)new GlobalProceduresRegistry());
            SystemGraphComponents.DefaultBuilder systemGraphComponentsBuilder = new SystemGraphComponents.DefaultBuilder();
            DbmsRuntimeSystemGraphComponent dbmsRuntimeSystemGraphComponent = new DbmsRuntimeSystemGraphComponent(this.globalModule.getGlobalConfig());
            systemGraphComponentsBuilder.register((SystemGraphComponent)dbmsRuntimeSystemGraphComponent);
            edition.registerSystemGraphComponents((SystemGraphComponents.Builder)systemGraphComponentsBuilder, this.globalModule);
            globalDependencies.satisfyDependency((Object)edition.getSystemGraphComponents());
            DatabaseContextProvider databaseContextProvider = edition.createDatabaseContextProvider(this.globalModule);
            ContextBasedSystemDatabaseProvider systemDatabaseProvider = new ContextBasedSystemDatabaseProvider(databaseContextProvider, this.globalModule.getDatabaseEventListeners());
            edition.createGlobalReadOnlyChecker((SystemDatabaseProvider)systemDatabaseProvider, databaseContextProvider.databaseIdRepository(), this.globalModule);
            edition.bootstrapQueryRouterServices(null);
            edition.registerDatabaseInitializers(this.globalModule, (SystemDatabaseProvider)systemDatabaseProvider);
            edition.createDefaultDatabaseResolver((SystemDatabaseProvider)systemDatabaseProvider);
            globalDependencies.satisfyDependency((Object)edition.getDefaultDatabaseResolver());
            edition.createSecurityModule(this.globalModule, (SystemDatabaseProvider)systemDatabaseProvider);
            SecurityProvider securityProvider = edition.getSecurityProvider();
            globalDependencies.satisfyDependencies(new Object[]{securityProvider.authManager()});
            DbmsRuntimeVersionProvider dbmsVersionProvider = edition.createAndRegisterDbmsRuntimeRepository(this.globalModule, databaseContextProvider, globalDependencies, dbmsRuntimeSystemGraphComponent);
            globalDependencies.satisfyDependency((Object)dbmsVersionProvider);
            globalLife.start();
            DatabaseContext systemContext = (DatabaseContext)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new IllegalStateException("Could not start System database"));
            this.systemDatabase = systemContext.databaseFacade();
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception toSuppress) {
                throw (Exception)Exceptions.chain((Throwable)e, (Throwable)toSuppress);
            }
            throw e;
        }
        return this;
    }

    public void close() {
        if (this.globalModule != null) {
            this.globalModule.getGlobalLife().shutdown();
            this.globalModule = null;
        }
    }

    public GlobalModule globalModule() {
        return this.globalModule;
    }

    public GraphDatabaseAPI systemDatabase() {
        return this.systemDatabase;
    }

    public static interface EditionModuleFactory
    extends Function<GlobalModule, AbstractEditionModule> {
    }
}

