/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module;

import java.nio.file.Path;
import java.time.Clock;
import java.util.function.Supplier;
import org.neo4j.capabilities.CapabilitiesService;
import org.neo4j.capabilities.DBMSCapabilities;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.cypher.internal.frontend.notification.InternalNotificationStats;
import org.neo4j.cypher.internal.frontend.phases.InternalUsageStats;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.OutOfDiskSpaceListener;
import org.neo4j.internal.collector.RecentQueryBuffer;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemLifecycleAdapter;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.locker.Locker;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.prefetch.PagePrefetcher;
import org.neo4j.io.pagecache.prefetch.PagePrefetcherFactory;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.diagnostics.providers.DbmsDiagnosticsManager;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.GlobalExtensions;
import org.neo4j.kernel.extension.context.GlobalExtensionContext;
import org.neo4j.kernel.impl.api.CommandCommitListeners;
import org.neo4j.kernel.impl.cache.VmPauseMonitorComponent;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.util.watcher.DefaultFileSystemWatcherService;
import org.neo4j.kernel.impl.util.watcher.FileSystemWatcherService;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.internal.event.DefaultGlobalTransactionEventListeners;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.internal.locker.GlobalLockerService;
import org.neo4j.kernel.internal.locker.LockerLifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.kernel.monitoring.ExceptionalDatabaseEvent;
import org.neo4j.kernel.monitoring.tracing.DefaultTracers;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.monitoring.ExceptionHandlerService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class GlobalModule {
    private final PageCache pageCache;
    private final Monitors globalMonitors;
    private final Dependencies globalDependencies;
    private final LogService logService;
    private final LifeSupport globalLife;
    private final Neo4jLayout neo4jLayout;
    private final DbmsInfo dbmsInfo;
    private final DbmsDiagnosticsManager dbmsDiagnosticsManager;
    private final Tracers tracers;
    private final Config globalConfig;
    private final FileSystemAbstraction fileSystem;
    private final GlobalExtensions globalExtensions;
    private final Iterable<ExtensionFactory<?>> extensionFactories;
    private final JobScheduler jobScheduler;
    private final SystemNanoClock globalClock;
    private final ConnectorPortRegister connectorPortRegister;
    private final CompositeDatabaseAvailabilityGuard globalAvailabilityGuard;
    private final FileSystemWatcherService fileSystemWatcher;
    private final DatabaseEventListeners databaseEventListeners;
    private final GlobalTransactionEventListeners transactionEventListeners;
    private final DependencyResolver externalDependencyResolver;
    private final FileLockerService fileLockerService;
    private final MemoryPools memoryPools;
    private final InternalNotificationStats cypherNotificationStats;
    private final InternalUsageStats cypherUsageStats;
    private final GlobalMemoryGroupTracker transactionsMemoryPool;
    private final GlobalMemoryGroupTracker otherMemoryPool;
    private final CapabilitiesService capabilitiesService;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final CommandCommitListeners defaultCommitListeners;
    private final PagePrefetcher pagePrefetcher;
    private final ExceptionHandlerService exceptionHandlerService;

    public GlobalModule(Config globalConfig, DbmsInfo dbmsInfo, boolean daemonMode, ExternalDependencies externalDependencies) {
        this.externalDependencyResolver = externalDependencies.dependencies() != null ? externalDependencies.dependencies() : new Dependencies();
        this.dbmsInfo = dbmsInfo;
        this.globalDependencies = new Dependencies();
        this.globalDependencies.satisfyDependency((Object)dbmsInfo);
        this.globalClock = (SystemNanoClock)this.globalDependencies.satisfyDependency((Object)this.createClock());
        this.globalLife = this.createLife();
        this.neo4jLayout = Neo4jLayout.of((Configuration)globalConfig);
        this.globalConfig = (Config)this.globalDependencies.satisfyDependency((Object)globalConfig);
        this.binarySupportedKernelVersions = new BinarySupportedKernelVersions(this.globalConfig);
        this.globalDependencies.satisfyDependency((Object)this.binarySupportedKernelVersions);
        this.fileSystem = this.tryResolveOrCreate(FileSystemAbstraction.class, this::createFileSystemAbstraction);
        this.globalDependencies.satisfyDependency((Object)this.fileSystem);
        this.globalLife.add((Lifecycle)new FileSystemLifecycleAdapter(this.fileSystem));
        this.logService = (LogService)this.globalDependencies.satisfyDependency((Object)this.createLogService(externalDependencies.userLogProvider(), daemonMode));
        globalConfig.setLogger(this.logService.getInternalLog(Config.class));
        this.globalMonitors = externalDependencies.monitors() == null ? new Monitors() : externalDependencies.monitors();
        this.globalDependencies.satisfyDependency((Object)this.globalMonitors);
        this.exceptionHandlerService = new ExceptionHandlerService(this.logService.getInternalLogProvider());
        this.globalDependencies.satisfyDependency((Object)this.exceptionHandlerService);
        JobScheduler createdOrResolvedScheduler = this.tryResolveOrCreate(JobScheduler.class, this::createJobScheduler);
        this.jobScheduler = (JobScheduler)this.globalLife.add((Lifecycle)((JobScheduler)this.globalDependencies.satisfyDependency((Object)createdOrResolvedScheduler)));
        this.defaultCommitListeners = this.tryResolveOrCreate(CommandCommitListeners.class, () -> CommandCommitListeners.NO_LISTENERS);
        this.fileLockerService = this.createFileLockerService();
        Locker storeLocker = this.fileLockerService.createStoreLocker(this.fileSystem, this.neo4jLayout);
        this.globalLife.add((Lifecycle)((LockerLifecycleAdapter)this.globalDependencies.satisfyDependency((Object)new LockerLifecycleAdapter(storeLocker))));
        new JvmChecker(this.logService.getInternalLog(JvmChecker.class), new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
        this.memoryPools = new MemoryPools(((Boolean)globalConfig.get(GraphDatabaseSettings.memory_tracking)).booleanValue());
        this.otherMemoryPool = this.memoryPools.pool(MemoryGroup.OTHER, 0L, null);
        this.transactionsMemoryPool = this.memoryPools.pool(MemoryGroup.TRANSACTION, ((Long)globalConfig.get(GraphDatabaseSettings.memory_transaction_global_max_size)).longValue(), GraphDatabaseSettings.memory_transaction_global_max_size.name());
        globalConfig.addListener(GraphDatabaseSettings.memory_transaction_global_max_size, (before, after) -> this.transactionsMemoryPool.setSize(after.longValue()));
        this.globalDependencies.satisfyDependency((Object)this.memoryPools);
        RecentQueryBuffer recentQueryBuffer = new RecentQueryBuffer(((Integer)globalConfig.get(GraphDatabaseInternalSettings.data_collector_max_recent_query_count)).intValue(), this.memoryPools.pool(MemoryGroup.RECENT_QUERY_BUFFER, 0L, null).getPoolMemoryTracker());
        this.globalDependencies.satisfyDependency((Object)recentQueryBuffer);
        if (((Boolean)globalConfig.get(GraphDatabaseInternalSettings.vm_pause_monitor_enabled)).booleanValue()) {
            this.globalLife.add((Lifecycle)new VmPauseMonitorComponent(globalConfig, this.logService.getInternalLog(VmPauseMonitorComponent.class), this.jobScheduler, this.globalMonitors));
        }
        this.globalAvailabilityGuard = new CompositeDatabaseAvailabilityGuard((Clock)this.globalClock, globalConfig);
        this.globalDependencies.satisfyDependency((Object)this.globalAvailabilityGuard);
        this.globalLife.setLast((Lifecycle)this.globalAvailabilityGuard);
        this.tracers = this.tryResolveOrCreate(Tracers.class, this::createDefaultTracers);
        this.globalDependencies.satisfyDependency((Object)this.tracers);
        this.globalDependencies.satisfyDependency((Object)this.tracers.getPageCacheTracer());
        this.pageCache = this.tryResolveOrCreate(PageCache.class, () -> this.createPageCache(this.fileSystem, globalConfig, this.logService, this.tracers, this.jobScheduler, this.globalClock, this.memoryPools));
        this.globalDependencies.satisfyDependency((Object)this.pageCache);
        this.globalLife.add((Lifecycle)new PageCacheLifecycle(this.pageCache));
        this.dbmsDiagnosticsManager = new DbmsDiagnosticsManager(this.globalDependencies, this.logService);
        this.globalDependencies.satisfyDependency((Object)this.dbmsDiagnosticsManager);
        this.globalLife.add(LifecycleAdapter.onInit(() -> ((DbmsDiagnosticsManager)this.dbmsDiagnosticsManager).dumpSystemDiagnostics()));
        this.fileSystemWatcher = this.createFileSystemWatcherService(this.fileSystem, this.logService, this.jobScheduler, globalConfig);
        this.globalLife.add((Lifecycle)this.fileSystemWatcher);
        this.globalDependencies.satisfyDependency((Object)this.fileSystemWatcher);
        this.extensionFactories = externalDependencies.extensions();
        this.globalExtensions = (GlobalExtensions)this.globalDependencies.satisfyDependency((Object)new GlobalExtensions(new GlobalExtensionContext(this.neo4jLayout, dbmsInfo, (DependencySatisfier)this.globalDependencies), this.extensionFactories, this.globalDependencies, ExtensionFailureStrategies.fail()));
        this.databaseEventListeners = new DatabaseEventListeners(this.logService.getInternalLog(DatabaseEventListeners.class));
        Iterable<DatabaseEventListener> externalListeners = externalDependencies.databaseEventListeners();
        for (DatabaseEventListener databaseListener : externalListeners) {
            this.databaseEventListeners.registerDatabaseEventListener(databaseListener);
        }
        this.databaseEventListeners.registerDatabaseEventListener((DatabaseEventListener)new DatabaseEventListenerAdapter(){

            public void databasePanic(DatabaseEventContext eventContext) {
                GlobalModule.this.exceptionHandlerService.raiseException("Database panic", ((ExceptionalDatabaseEvent)eventContext).getCause());
            }
        });
        this.globalDependencies.satisfyDependencies(new Object[]{this.databaseEventListeners});
        this.cypherNotificationStats = new InternalNotificationStats();
        this.globalDependencies.satisfyDependencies(new Object[]{this.cypherNotificationStats});
        this.cypherUsageStats = InternalUsageStats.newImpl();
        this.globalDependencies.satisfyDependencies(new Object[]{this.cypherUsageStats});
        OutOfDiskSpaceListener outOfDiskSpaceListener = new OutOfDiskSpaceListener(globalConfig, this.logService.getInternalLog(OutOfDiskSpaceListener.class));
        this.databaseEventListeners.registerDatabaseEventListener((DatabaseEventListener)outOfDiskSpaceListener);
        this.transactionEventListeners = this.createGlobalTransactionEventListeners();
        this.globalDependencies.satisfyDependency((Object)this.transactionEventListeners);
        this.connectorPortRegister = new ConnectorPortRegister();
        this.globalDependencies.satisfyDependency((Object)this.connectorPortRegister);
        this.capabilitiesService = this.loadCapabilities();
        this.globalDependencies.satisfyDependency((Object)this.capabilitiesService);
        this.globalDependencies.satisfyDependency((Object)this.tryResolveOrCreate(NativeAccess.class, NativeAccessProvider::getNativeAccess));
        this.pagePrefetcher = this.tryResolveOrCreate(PagePrefetcher.class, this::createPrefetcher);
        this.globalLife.add((Lifecycle)this.pagePrefetcher);
    }

    private PagePrefetcher createPrefetcher() {
        if (((Boolean)this.globalConfig.get(GraphDatabaseInternalSettings.prefetch_on_commit)).booleanValue()) {
            return PagePrefetcherFactory.getInstance().create(this.pageCache, this.jobScheduler, new CursorContextFactory(this.tracers.getPageCacheTracer(), FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER), this.logService.getInternalLog(PagePrefetcher.class));
        }
        return PagePrefetcher.DISABLED;
    }

    private Tracers createDefaultTracers() {
        String desiredImplementationName = (String)this.globalConfig.get(GraphDatabaseInternalSettings.tracer);
        return new DefaultTracers(desiredImplementationName, this.logService.getInternalLog(DefaultTracers.class), this.globalMonitors, this.jobScheduler, this.globalClock, this.globalConfig);
    }

    private <T> T tryResolveOrCreate(Class<T> clazz, Supplier<T> newInstanceMethod) {
        return this.externalDependencyResolver.resolveOptionalDependency(clazz).orElseGet(newInstanceMethod);
    }

    protected FileLockerService createFileLockerService() {
        return new GlobalLockerService();
    }

    protected SystemNanoClock createClock() {
        return Clocks.nanoClock();
    }

    public LifeSupport createLife() {
        return new LifeSupport();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    private FileSystemWatcherService createFileSystemWatcherService(FileSystemAbstraction fileSystem, LogService logging, JobScheduler jobScheduler, Config config) {
        if (!((Boolean)config.get(GraphDatabaseSettings.filewatcher_enabled)).booleanValue()) {
            InternalLog log = logging.getInternalLog(this.getClass());
            log.info("File watcher disabled by configuration.");
            return FileSystemWatcherService.EMPTY_WATCHER;
        }
        try {
            return new DefaultFileSystemWatcherService(jobScheduler, fileSystem.fileWatcher(), (LogProvider)logging.getInternalLogProvider());
        }
        catch (Exception e) {
            InternalLog log = logging.getInternalLog(this.getClass());
            log.warn("Can not create file watcher for current file system. File monitoring capabilities for store files will be disabled.", (Throwable)e);
            return FileSystemWatcherService.EMPTY_WATCHER;
        }
    }

    protected LogService createLogService(InternalLogProvider userLogProvider, boolean daemonMode) {
        userLogProvider = userLogProvider == null ? NullLogProvider.getInstance() : userLogProvider;
        NullLogProvider internalLogProvider = NullLogProvider.getInstance();
        if (((Boolean)this.globalConfig.get(GraphDatabaseSettings.debug_log_enabled)).booleanValue()) {
            Path xmlConfig = (Path)this.globalConfig.get(GraphDatabaseSettings.server_logging_config_path);
            boolean allowDefaultXmlConfig = !this.globalConfig.isExplicitlySet(GraphDatabaseSettings.server_logging_config_path);
            Neo4jLoggerContext loggerContext = LogConfig.createLoggerFromXmlConfig((FileSystemAbstraction)this.fileSystem, (Path)xmlConfig, (boolean)allowDefaultXmlConfig, (boolean)daemonMode, arg_0 -> ((Config)this.globalConfig).configStringLookup(arg_0), log -> {
                if (this.dbmsDiagnosticsManager != null) {
                    this.dbmsDiagnosticsManager.dumpAll(log);
                }
            }, (String)DiagnosticsManager.class.getCanonicalName());
            loggerContext.getLogger(this.getClass()).info("Logging config in use: " + loggerContext.getConfigSourceInfo());
            internalLogProvider = new Log4jLogProvider(loggerContext);
        }
        SimpleLogService logService = new SimpleLogService(userLogProvider, (InternalLogProvider)internalLogProvider, ((Boolean)this.globalConfig.get(GraphDatabaseInternalSettings.duplication_user_messages)).booleanValue());
        return (LogService)this.globalLife.add((Lifecycle)logService);
    }

    protected GlobalTransactionEventListeners createGlobalTransactionEventListeners() {
        return new DefaultGlobalTransactionEventListeners();
    }

    private JobScheduler createJobScheduler() {
        JobScheduler jobScheduler = JobSchedulerFactory.createScheduler((SystemNanoClock)this.globalClock, (InternalLogProvider)this.logService.getInternalLogProvider());
        jobScheduler.setParallelism(Group.INDEX_SAMPLING, ((Integer)this.globalConfig.get(GraphDatabaseInternalSettings.index_sampling_parallelism)).intValue());
        jobScheduler.setParallelism(Group.INDEX_POPULATION, ((Integer)this.globalConfig.get(GraphDatabaseInternalSettings.index_population_parallelism)).intValue());
        jobScheduler.setParallelism(Group.PAGE_CACHE_PRE_FETCHER, ((Integer)this.globalConfig.get(GraphDatabaseSettings.pagecache_scan_prefetch)).intValue());
        jobScheduler.setParallelism(Group.INDEX_UPDATING, ((Integer)this.globalConfig.get(FulltextSettings.eventually_consistent_apply_parallelism)).intValue());
        jobScheduler.setParallelism(Group.INDEX_REFRESHING, ((Integer)this.globalConfig.get(FulltextSettings.eventually_consistent_refresh_parallelism)).intValue());
        return jobScheduler;
    }

    protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers, JobScheduler jobScheduler, SystemNanoClock clock, MemoryPools memoryPools) {
        InternalLog pageCacheLog = logging.getInternalLog(PageCache.class);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, tracers.getPageCacheTracer(), pageCacheLog, jobScheduler, clock, memoryPools);
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        if (((Boolean)config.get(GraphDatabaseInternalSettings.dump_configuration)).booleanValue()) {
            pageCacheFactory.dumpConfiguration();
        }
        return pageCache;
    }

    private CapabilitiesService loadCapabilities() {
        CapabilitiesService service = CapabilitiesService.newCapabilities((Configuration)this.globalConfig, (DependencyResolver)this.globalDependencies);
        service.set(DBMSCapabilities.dbms_instance_version, (Object)Version.getNeo4jVersion());
        service.set(DBMSCapabilities.dbms_instance_kernel_version, (Object)Version.getKernelVersion());
        service.set(DBMSCapabilities.dbms_instance_edition, (Object)this.dbmsInfo.edition.toString());
        return service;
    }

    public FileWatcher getFileWatcher() {
        return this.fileSystemWatcher.getFileWatcher();
    }

    public ConnectorPortRegister getConnectorPortRegister() {
        return this.connectorPortRegister;
    }

    public SystemNanoClock getGlobalClock() {
        return this.globalClock;
    }

    public JobScheduler getJobScheduler() {
        return this.jobScheduler;
    }

    public GlobalExtensions getGlobalExtensions() {
        return this.globalExtensions;
    }

    Iterable<ExtensionFactory<?>> getExtensionFactories() {
        return this.extensionFactories;
    }

    public Config getGlobalConfig() {
        return this.globalConfig;
    }

    public FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }

    public BinarySupportedKernelVersions getBinarySupportedKernelVersions() {
        return this.binarySupportedKernelVersions;
    }

    public Tracers getTracers() {
        return this.tracers;
    }

    public Neo4jLayout getNeo4jLayout() {
        return this.neo4jLayout;
    }

    public DbmsInfo getDbmsInfo() {
        return this.dbmsInfo;
    }

    public LifeSupport getGlobalLife() {
        return this.globalLife;
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public Monitors getGlobalMonitors() {
        return this.globalMonitors;
    }

    public Dependencies getGlobalDependencies() {
        return this.globalDependencies;
    }

    public LogService getLogService() {
        return this.logService;
    }

    public CompositeDatabaseAvailabilityGuard getGlobalAvailabilityGuard() {
        return this.globalAvailabilityGuard;
    }

    public DatabaseEventListeners getDatabaseEventListeners() {
        return this.databaseEventListeners;
    }

    public GlobalTransactionEventListeners getTransactionEventListeners() {
        return this.transactionEventListeners;
    }

    public DependencyResolver getExternalDependencyResolver() {
        return this.externalDependencyResolver;
    }

    FileLockerService getFileLockerService() {
        return this.fileLockerService;
    }

    public MemoryPools getMemoryPools() {
        return this.memoryPools;
    }

    public GlobalMemoryGroupTracker getTransactionsMemoryPool() {
        return this.transactionsMemoryPool;
    }

    public GlobalMemoryGroupTracker getOtherMemoryPool() {
        return this.otherMemoryPool;
    }

    public CapabilitiesService getCapabilitiesService() {
        return this.capabilitiesService;
    }

    public CommandCommitListeners getDefaultCommandCommitListeners() {
        return this.defaultCommitListeners;
    }

    public PagePrefetcher getPagePrefetcher() {
        return this.pagePrefetcher;
    }

    public ExceptionHandlerService getExceptionHandlerService() {
        return this.exceptionHandlerService;
    }
}

