/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.PrintStream;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.io.IOUtils;
import org.neo4j.server.startup.BootProcessFailureException;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.BootloaderOsAbstraction;
import org.neo4j.server.startup.ErrorGobbler;
import org.neo4j.server.startup.ProcessManager;
import org.neo4j.server.startup.ProcessStages;

abstract class AbstractUnixBootloaderOs
extends BootloaderOsAbstraction {
    AbstractUnixBootloaderOs(Bootloader bootloader) {
        super(bootloader);
    }

    @Override
    long start() {
        return this.bootloader.processManager().run(this.buildStandardStartArguments(), new StartProcess(this.bootloader.environment.err()));
    }

    @Override
    void stop(long pid) throws CommandFailedException {
        this.getProcessIfAlive(pid).ifPresent(this::destroyOrFail);
    }

    private void destroyOrFail(ProcessHandle process) throws CommandFailedException {
        boolean couldIssueDestroy = process.destroy();
        if (!couldIssueDestroy) {
            String stopInvokingUser = System.getProperty("user.name");
            process.info().user().ifPresentOrElse(otherProcessUser -> {
                String msg = String.format("Failed to stop process. User of the process to stop '%s' and user running this process '%s' differs, which means this could be a permission problem.", otherProcessUser, stopInvokingUser);
                throw new CommandFailedException(msg);
            }, () -> {
                throw new CommandFailedException("Failed to stop process.");
            });
        }
    }

    @Override
    long console() throws CommandFailedException {
        return this.bootloader.processManager().run(this.buildStandardStartArguments(), new UnixConsoleProcess());
    }

    @Override
    void installService() throws CommandFailedException {
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    @Override
    void uninstallService() throws CommandFailedException {
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    @Override
    void updateService() throws CommandFailedException {
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    @Override
    boolean serviceInstalled() {
        throw new UnsupportedOperationException("Not supported on this OS");
    }

    @Override
    Optional<Long> getPidIfRunning() {
        return this.getProcessIfAlive(this.bootloader.processManager().getPidFromFile()).map(ProcessHandle::pid);
    }

    @Override
    boolean isRunning(long pid) {
        return this.getProcessIfAlive(pid).isPresent();
    }

    private Optional<ProcessHandle> getProcessIfAlive(Long pid) {
        if (pid != null) {
            return this.bootloader.processManager().getProcessHandle(pid);
        }
        return Optional.empty();
    }

    private static class StartProcess
    implements ProcessStages {
        private final PrintStream errorStream;

        private StartProcess(PrintStream errorStream) {
            this.errorStream = errorStream;
        }

        @Override
        public void preStart(ProcessManager processManager, ProcessBuilder processBuilder) {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }

        @Override
        public void postStart(ProcessManager processManager, Process process) throws Exception {
            ErrorGobbler errorGobbler = new ErrorGobbler(this.errorStream, process.getErrorStream());
            errorGobbler.start();
            processManager.storePid(process.pid(), true);
            boolean success = errorGobbler.waitUntilFullyFledged();
            errorGobbler.join(TimeUnit.MINUTES.toMillis(1L));
            IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{process.getOutputStream(), process.getErrorStream(), process.getInputStream()});
            if (!success) {
                if (process.waitFor(1L, TimeUnit.MINUTES)) {
                    int code = process.exitValue();
                    throw new BootProcessFailureException(BootloaderOsAbstraction.NEO4J_PROCESS_EXITCODE_MAPPER.map(code), code);
                }
                throw new CommandFailedException("Failed to start server.");
            }
        }
    }

    static class UnixConsoleProcess
    extends BootloaderOsAbstraction.ConsoleProcess {
        UnixConsoleProcess() {
            super(true);
        }

        @Override
        public void postStart(ProcessManager processManager, Process process) throws Exception {
            processManager.storePid(process.pid(), false);
            super.postStart(processManager, process);
        }
    }
}

