/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.server.startup.CliDumper;
import org.neo4j.server.startup.Environment;
import org.neo4j.server.startup.Neo4jAdminCommand;
import org.neo4j.server.startup.Neo4jCommand;
import picocli.CommandLine;

@CommandLine.Command(name="generate-cli-dump", description={"Generates cli dump"})
public class CliDumpGenerator
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Output directory"})
    private Path output;

    private void dumpCli(Neo4jAdminCommand command) throws IOException {
        CommandLine commandLine = command.getActualAdminCommand(new ExecutionContext(this.output, this.output));
        String name = commandLine.getCommand().getClass().getAnnotation(CommandLine.Command.class).name();
        Path file = this.output.resolve(name + "_dump.csv");
        String dump = new CliDumper(true, true, false).dump(commandLine);
        Files.writeString(file, (CharSequence)dump, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public Integer call() throws Exception {
        if (Files.exists(this.output, new LinkOption[0]) && !Files.isDirectory(this.output, new LinkOption[0])) {
            throw new FileAlreadyExistsException(this.output.toString() + " Needs to be a directory");
        }
        Files.createDirectories(this.output, new FileAttribute[0]);
        this.dumpCli(new Neo4jAdminCommand(Environment.SYSTEM));
        this.dumpCli(new Neo4jCommand(Environment.SYSTEM));
        return 0;
    }

    public static void main(String[] args) {
        new CommandLine((Object)new CliDumpGenerator()).execute(args);
    }
}

