/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.server.startup.Neo4jAdminCommand;
import picocli.CommandLine;

public class CliDumper {
    private static final String SEPARATOR = ";";
    private final boolean includeHidden;
    private final boolean includeDescription;
    private final boolean includeType;

    public CliDumper(boolean includeHidden, boolean includeDescription, boolean includeOptionType) {
        this.includeHidden = includeHidden;
        this.includeDescription = includeDescription;
        this.includeType = includeOptionType;
    }

    public String dump(Neo4jAdminCommand cmd) {
        return this.dump(cmd.getActualAdminCommand(new ExecutionContext(Path.of("", new String[0]), Path.of("", new String[0]))));
    }

    public String dump(CommandLine cmd) {
        StringBuilder stringBuilder = new StringBuilder();
        int numCommands = CliDumper.getNumCommands(cmd, 1);
        stringBuilder.append(CliDumper.header(numCommands));
        this.dump(cmd, 0, new String[numCommands], stringBuilder);
        return stringBuilder.toString();
    }

    private void dump(CommandLine cmd, int depth, String[] commands, StringBuilder stringBuilder) {
        CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
        Object name = cmd.getCommandName();
        if (spec.usageMessage().hidden()) {
            if (!this.includeHidden) {
                return;
            }
            name = (String)name + " <HIDDEN>";
        }
        commands[depth] = name;
        StringBuilder commandAndParams = new StringBuilder();
        for (String com : commands) {
            commandAndParams.append(com != null ? com : "").append(SEPARATOR);
        }
        String paramOptions = this.addParams(commandAndParams, spec);
        String comAndParams = commandAndParams.append(SEPARATOR).toString();
        for (CommandLine.Model.OptionSpec os : spec.options()) {
            if (os.hidden() && !this.includeHidden) continue;
            stringBuilder.append(comAndParams).append(Arrays.toString(os.names())).append(os.hidden() && this.includeHidden ? " <HIDDEN>" : "").append(SEPARATOR).append(paramOptions).append(SEPARATOR).append((String)(this.includeType ? " " + os.type().getSimpleName() : "")).append(this.includeDescription ? CliDumper.asOneLine(os.description()) : "").append(System.lineSeparator());
        }
        cmd.getSubcommands().values().stream().distinct().forEach(subCmd -> this.dump((CommandLine)subCmd, depth + 1, commands, stringBuilder));
    }

    private static int getNumCommands(CommandLine cmd, int depth) {
        return cmd.getSubcommands().values().stream().distinct().map(c -> CliDumper.getNumCommands(c, depth + 1)).max(Integer::compare).orElse(depth);
    }

    private static String header(int numCommands) {
        StringBuilder header = new StringBuilder();
        for (int i = 1; i <= numCommands; ++i) {
            header.append("Command ").append(i).append(SEPARATOR);
        }
        header.append("Parameters").append(SEPARATOR).append("Option").append(SEPARATOR).append("Param descriptions").append(SEPARATOR).append("Option description").append(System.lineSeparator());
        return header.toString();
    }

    private String addParams(StringBuilder commandAndParams, CommandLine.Model.CommandSpec spec) {
        List params = spec.positionalParameters();
        StringBuilder paramOptions = new StringBuilder();
        for (CommandLine.Model.PositionalParamSpec param : params) {
            if (param.hidden() && !this.includeHidden) continue;
            commandAndParams.append(param.paramLabel());
            commandAndParams.append((String)(this.includeType ? " " + param.type().getSimpleName() : ""));
            commandAndParams.append(param.hidden() && this.includeHidden ? " <HIDDEN>" : "");
            commandAndParams.append(" ");
            paramOptions.append(this.includeDescription ? CliDumper.asOneLine(param.description()) : "").append(" ");
        }
        return paramOptions.toString();
    }

    private static String asOneLine(String[] strings) {
        return Arrays.toString(strings).replace(System.lineSeparator(), " ").replace("%n", "");
    }
}

