/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import org.neo4j.string.EncodingUtils;

class ErrorGobbler
extends Thread {
    private final PrintStream parentProcessStdErr;
    private final BufferedReader childProcessStdErr;
    private final CountDownLatch blockParent = new CountDownLatch(1);
    private volatile IOException exception;
    private volatile boolean success;

    ErrorGobbler(PrintStream parentProcessStdErr, InputStream childProcessStdErr) {
        super(ErrorGobbler.class.getSimpleName());
        this.parentProcessStdErr = parentProcessStdErr;
        this.childProcessStdErr = new BufferedReader(new InputStreamReader(childProcessStdErr, EncodingUtils.getNativeCharset()));
        this.setDaemon(true);
        this.setUncaughtExceptionHandler((t, e) -> e.printStackTrace(parentProcessStdErr));
    }

    boolean waitUntilFullyFledged() throws IOException {
        try {
            this.blockParent.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for child process to bootstrap.", e);
        }
        if (this.exception != null) {
            throw new IOException("Error while waiting for child process.", this.exception);
        }
        return this.success;
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.childProcessStdErr.readLine()) != null) {
                if (!line.isEmpty() && line.charAt(0) == '\u0006') {
                    this.success = true;
                    this.blockParent.countDown();
                    continue;
                }
                this.parentProcessStdErr.println(line);
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
        finally {
            this.parentProcessStdErr.flush();
            this.blockParent.countDown();
        }
    }
}

