/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.AdminTool;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.EnhancedExecutionContext;
import org.neo4j.server.startup.Environment;
import org.neo4j.server.startup.VerboseCommand;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="Neo4j Admin", description={"Neo4j Admin CLI."})
public class Neo4jAdminCommand
implements Callable<Integer>,
VerboseCommand {
    private final Class<?> entrypoint;
    private final Environment environment;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--expand-commands"}, hidden=true, description={"Allow command expansion in config value evaluation."})
    boolean expandCommands;
    @CommandLine.Option(names={"--verbose"}, hidden=true, description={"Prints additional information."})
    boolean verbose;

    public Neo4jAdminCommand(Environment environment) {
        this(AdminTool.class, environment);
    }

    protected Neo4jAdminCommand(Class<?> entrypoint, Environment environment) {
        this.entrypoint = entrypoint;
        this.environment = environment;
    }

    @Override
    public Integer call() throws Exception {
        ExecArguments execArgs = this.buildExecArgs();
        try (Bootloader.Admin adminBootloader = this.createAdminBootloader(execArgs.arguments);){
            Integer n;
            ExecutionInfo executionInfo;
            EnhancedExecutionContext ctx = new EnhancedExecutionContext(adminBootloader.home(), adminBootloader.confDir(), this.environment.out(), this.environment.err(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), this::createDbmsBootloader, adminBootloader.getPluginClassLoader());
            CommandLine actualCommand = this.getActualAdminCommand(ctx);
            if (!execArgs.hasSubCommandArguments) {
                actualCommand.usage(adminBootloader.environment.err());
                Integer n2 = 2;
                return n2;
            }
            CommandLine.ParseResult result = actualCommand.parseArgs(execArgs.arguments);
            Integer code = CommandLine.executeHelpRequest((CommandLine.ParseResult)result);
            if (code != null) {
                Integer n3 = code;
                return n3;
            }
            try {
                executionInfo = this.getExecutionInfo(result);
            }
            catch (CommandLine.ParameterException e) {
                if (e.getCommandLine() == actualCommand && e instanceof CommandLine.UnmatchedArgumentException) {
                    Map subcommands = actualCommand.getSubcommands();
                    HashMap<String, CommandLine> permutations = new HashMap<String, CommandLine>();
                    subcommands.forEach((outerName, outerSubCommand) -> outerSubCommand.getSubcommands().keySet().forEach(innerName -> permutations.put(outerName + " " + innerName, (CommandLine)outerSubCommand)));
                    permutations.forEach((arg_0, arg_1) -> ((CommandLine)actualCommand).addSubcommand(arg_0, arg_1));
                }
                Integer n4 = e.getCommandLine().getParameterExceptionHandler().handleParseException(e, execArgs.arguments);
                return n4;
            }
            if (executionInfo.forkingAdminCommand) {
                n = adminBootloader.admin(executionInfo.additionalConfigs);
                return n;
            }
            n = actualCommand.execute(execArgs.arguments);
            return n;
        }
    }

    private ExecArguments buildExecArgs() {
        List originalArgs = this.spec.commandLine().getParseResult().originalArgs();
        int unmatchedCount = originalArgs.size();
        if (this.expandCommands) {
            --unmatchedCount;
        }
        if (this.verbose) {
            --unmatchedCount;
        }
        return new ExecArguments(originalArgs.toArray(new String[0]), unmatchedCount > 0);
    }

    private ExecutionInfo getExecutionInfo(CommandLine.ParseResult parseResult) {
        for (CommandLine commandLine : parseResult.asCommandLineList()) {
            Object object = commandLine.getCommand();
            if (!(object instanceof AbstractAdminCommand)) continue;
            AbstractAdminCommand adminCommand = (AbstractAdminCommand)object;
            return new ExecutionInfo(true, adminCommand.getCommandConfigs());
        }
        return new ExecutionInfo(false, List.of());
    }

    protected CommandLine getActualAdminCommand(ExecutionContext executionContext) {
        return AdminTool.getCommandLine((ExecutionContext)executionContext);
    }

    @VisibleForTesting
    protected Bootloader.Admin createAdminBootloader(String[] args) {
        return new Bootloader.Admin(this.entrypoint, this.environment, this.expandCommands, this.verbose, args);
    }

    @VisibleForTesting
    protected Bootloader.Dbms createDbmsBootloader() {
        return new Bootloader.Dbms(this.environment, this.expandCommands, this.verbose);
    }

    @Override
    public boolean verbose() {
        return this.verbose;
    }

    static CommandLine asCommandLine(Neo4jAdminCommand command, Environment environment) {
        return new CommandLine((Object)command).setCaseInsensitiveEnumValuesAllowed(true).setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExceptionHandler(environment)).setOut(new PrintWriter(environment.out(), true)).setErr(new PrintWriter(environment.err(), true)).setUnmatchedArgumentsAllowed(true).setUnmatchedOptionsArePositionalParams(true).setExpandAtFiles(false);
    }

    public static void main(String[] args) {
        Environment environment = Environment.SYSTEM;
        int exitCode = Neo4jAdminCommand.asCommandLine(new Neo4jAdminCommand(environment), environment).execute(args);
        System.exit(exitCode);
    }

    private record ExecArguments(String[] arguments, boolean hasSubCommandArguments) {
    }

    private record ExecutionInfo(boolean forkingAdminCommand, List<Path> additionalConfigs) {
    }

    private static class ExceptionHandler
    implements CommandLine.IExecutionExceptionHandler {
        private final Environment environment;

        ExceptionHandler(Environment environment) {
            this.environment = environment;
        }

        public int handleExecutionException(Exception exception, CommandLine commandLine, CommandLine.ParseResult parseResult) {
            if (commandLine.getCommand() instanceof VerboseCommand && !((VerboseCommand)commandLine.getCommand()).verbose()) {
                this.environment.err().println(exception.getMessage());
                this.environment.err().println("Run with '--verbose' for a more detailed error message.");
            } else {
                exception.printStackTrace(this.environment.err());
            }
            if (exception instanceof CommandFailedException) {
                CommandFailedException failure = (CommandFailedException)((Object)exception);
                return failure.getExitCode();
            }
            return commandLine.getCommandSpec().exitCodeOnExecutionException();
        }
    }
}

