/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.ai.text.completion.provider;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.genai.ai.text.completion.TextCompletion;
import org.neo4j.genai.ai.text.completion.provider.ResponseModel;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.JsonUtils;
import org.neo4j.genai.util.MalformedGenAIResponseException;
import org.neo4j.genai.util.Parameters;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.virtual.MapValue;

public interface OpenAiBase<PARAMS>
extends TextCompletion.Provider.Implementation {
    public URI endpoint();

    public HttpService httpService();

    public Class<PARAMS> paramType();

    public String[] authHeader(PARAMS var1);

    public void extendPayload(MutableMap<String, Object> var1, PARAMS var2);

    @Override
    default public String complete(String prompt, MapValue paramMap) {
        return this.complete(prompt, Parameters.parse(this.paramType(), paramMap));
    }

    private String complete(String prompt, PARAMS params) {
        MutableMap<String, Object> payload = this.payload(List.of(prompt), params);
        List response = this.httpService().request(this.endpoint(), builder -> builder.headers("Content-Type", "application/json; charset=" + String.valueOf(StandardCharsets.UTF_8), "Accept", "application/json").headers(this.authHeader(params)).POST(HttpService.jsonBody(payload)).build(), OpenAiBase::parseResponse);
        if (response.size() != 1) {
            throw new MalformedGenAIResponseException("Expected exactly one message, but found " + response.size());
        }
        return (String)response.getFirst();
    }

    @VisibleForTesting
    private static List<String> parseResponse(InputStream inputStream) throws MalformedGenAIResponseException {
        ResponseModel.Response response = JsonUtils.readValue(inputStream, ResponseModel.Response.class);
        return response.output().stream().filter(o -> "message".equals(o.type())).flatMap(o -> o.content().stream()).filter(c -> "output_text".equals(c.type())).map(ResponseModel.Content::text).toList();
    }

    private MutableMap<String, Object> payload(List<String> prompts, PARAMS params) {
        MutableMap payload = Maps.mutable.empty();
        this.extendPayload((MutableMap<String, Object>)payload, params);
        List<Map> messages = prompts.stream().map(prompt -> Map.of("role", "user", "content", prompt)).toList();
        payload.put((Object)"input", messages);
        return payload;
    }
}

