/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.dbs;

import java.util.Map;
import java.util.Optional;
import org.neo4j.genai.dbs.Constants;

public record EntityMappingConfig(String metadataKey, String entityKey, String nodeLabel, String relType, String embeddingKey, String similarity, MappingMode mode) {
    private EntityMappingConfig(Map<String, Object> mapping, Boolean forceReadOnly) {
        this(Keys.METADATA.get(String.class, mapping), Keys.ENTITY.get(String.class, mapping), Keys.NODE_LABEL.get(String.class, mapping), Keys.REL_TYPE.get(String.class, mapping), Keys.EMBEDDING.get(String.class, mapping), Keys.SIMILARITY.get(String.class, mapping), Boolean.TRUE.equals(forceReadOnly) ? MappingMode.READ_ONLY : MappingMode.valueOf(Keys.MODE.get(String.class, mapping)));
    }

    static EntityMappingConfig of(Map<String, Object> config, Boolean forceReadOnly) {
        return new EntityMappingConfig(config == null ? Map.of() : config, forceReadOnly);
    }

    public boolean readOnly() {
        return this.mode() == MappingMode.READ_ONLY;
    }

    static enum MappingMode {
        READ_ONLY,
        UPDATE_EXISTING,
        CREATE_IF_MISSING;

    }

    public static enum Keys implements Constants
    {
        METADATA("metadataKey"),
        ENTITY("entityKey"),
        NODE_LABEL("nodeLabel"),
        REL_TYPE("relType"),
        EMBEDDING("embeddingKey"),
        SIMILARITY("similarity", "cosine"),
        MODE("mode", MappingMode.UPDATE_EXISTING.toString());

        private final String key;
        private final Object defaultValue;

        private Keys(String value) {
            this(value, null);
        }

        private Keys(String value, Object defaultValue) {
            this.key = value;
            this.defaultValue = defaultValue;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Optional<Object> defaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }
    }
}

