/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.factory.primitive.IntObjectMaps;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.genai.util.GenAIProcedureException;
import org.neo4j.genai.util.JsonUtils;
import org.neo4j.genai.util.MalformedGenAIResponseException;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;

public final class HttpService {
    private static final String USER_AGENT = "Neo4j-GenAIProcedures/1.2.0";
    private static final ImmutableIntSet defaultAcceptableStatusCodes = IntSets.immutable.of(200);
    private final URLAccessChecker urlAccessChecker;
    public static final Function<InputStream, Map<String, Object>> DEFAULT_RESPONSE_TO_MAP_TRANSFORMER = inputStream -> {
        try {
            return (Map)JsonUtils.getObjectMapper().readValue(inputStream, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };

    public HttpService(URLAccessChecker urlAccessChecker) {
        this.urlAccessChecker = urlAccessChecker;
    }

    public static HttpRequest.BodyPublisher pipe(ThrowingConsumer<OutputStream, IOException> outputStreamConsumer) {
        return HttpRequest.BodyPublishers.ofInputStream(() -> {
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream();
            try {
                out.connect(in);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Thread.ofVirtual().start(() -> {
                try (PipedOutputStream pipedOutputStream = out;){
                    outputStreamConsumer.accept((Object)out);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return in;
        });
    }

    public static HttpRequest.BodyPublisher jsonBody(Object payload) {
        return HttpService.pipe((ThrowingConsumer<OutputStream, IOException>)((ThrowingConsumer)out -> JsonUtils.getObjectMapper().writeValue(out, payload)));
    }

    public <T> T request(URI target, Function<HttpRequest.Builder, HttpRequest> requestCustomizer, Function<InputStream, T> transformer) {
        return this.request(target, requestCustomizer, transformer, (IntSet)defaultAcceptableStatusCodes);
    }

    public <T> T request(URI target, Function<HttpRequest.Builder, HttpRequest> requestCustomizer, Function<InputStream, T> transformer, IntSet acceptableStatusCodes) {
        return this.request(target, requestCustomizer, transformer, acceptableStatusCodes, (IntObjectMap<Supplier<GenAIProcedureException>>)IntObjectMaps.immutable.empty(), (a, b) -> Optional.empty());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T> T request(URI target, Function<HttpRequest.Builder, HttpRequest> requestCustomizer, Function<InputStream, T> transformer, IntSet acceptableStatusCodes, IntObjectMap<Supplier<GenAIProcedureException>> unacceptableStatusCodes, BiFunction<Integer, String, Optional<GenAIProcedureException>> providerSpecificStatusHandler) {
        try {
            this.urlAccessChecker.checkURL(target.toURL());
        }
        catch (MalformedURLException | URLAccessValidationError e) {
            throw new GenAIProcedureException("Request failed: " + e.getMessage(), e);
        }
        try (HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).executor(Executors.newVirtualThreadPerTaskExecutor()).build();){
            InputStream inputStream;
            block20: {
                HttpRequest request = requestCustomizer.apply(HttpRequest.newBuilder().uri(target).header("User-Agent", USER_AGENT));
                BodyAndErrorHandler<InputStream, String> handler = new BodyAndErrorHandler<InputStream, String>(HttpResponse.BodyHandlers.ofInputStream(), HttpResponse.BodyHandlers.ofString());
                HttpResponse response = httpClient.send(request, handler);
                int responseCode = response.statusCode();
                if (responseCode == 401) {
                    throw new GenAIProcedureException("Not authorized to make API request; check your credentials.", responseCode);
                }
                if (responseCode == 403) {
                    throw new GenAIProcedureException("API request forbidden (HTTP response code: 403); check your credentials.", responseCode);
                }
                if (!acceptableStatusCodes.contains(responseCode)) {
                    String errorMessage = (String)((Response)response.body()).error();
                    throw providerSpecificStatusHandler.apply(responseCode, errorMessage).orElseGet((Supplier)unacceptableStatusCodes.getIfAbsent(responseCode, (Function0 & Serializable)() -> () -> new MalformedGenAIResponseException("Unexpected HTTP response code: " + responseCode + (String)(errorMessage.isBlank() ? "" : " - " + errorMessage), responseCode)));
                }
                InputStream inputStream2 = (InputStream)((Response)response.body()).value();
                try {
                    inputStream = transformer.apply(inputStream2);
                    if (inputStream2 == null) break block20;
                }
                catch (Throwable throwable) {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream2.close();
            }
            return (T)inputStream;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GenAIProcedureException("Could not finish request", e);
        }
    }

    static final class BodyAndErrorHandler<R, T>
    implements HttpResponse.BodyHandler<Response<R, T>> {
        private final HttpResponse.BodyHandler<R> responseHandler;
        private final HttpResponse.BodyHandler<T> errorHandler;

        BodyAndErrorHandler(HttpResponse.BodyHandler<R> responseHandler, HttpResponse.BodyHandler<T> errorHandler) {
            this.responseHandler = responseHandler;
            this.errorHandler = errorHandler;
        }

        @Override
        public HttpResponse.BodySubscriber<Response<R, T>> apply(HttpResponse.ResponseInfo responseInfo) {
            if (responseInfo.statusCode() == 200) {
                return HttpResponse.BodySubscribers.mapping(this.responseHandler.apply(responseInfo), r -> new Response<Object, Object>(r, null));
            }
            return HttpResponse.BodySubscribers.mapping(this.errorHandler.apply(responseInfo), t -> new Response<Object, Object>(null, t));
        }
    }

    record Response<R, T>(R value, T error) {
    }
}

